/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.ForwardLogic;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.NextOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import java.util.HashMap;
import java.util.Map;

public class SwitchForward
implements ForwardLogic {
    private final Map<String, ForwardLogic> m_switchMap = new HashMap<String, ForwardLogic>();
    private final String m_pageId;
    private final String m_fieldId;

    public SwitchForward(String currentPage, String fieldId) {
        String field;
        String[] complexField = fieldId.split("/");
        String page = currentPage;
        if (complexField.length == 1) {
            field = fieldId;
        } else {
            page = complexField[0];
            field = complexField[1];
        }
        this.m_pageId = page;
        this.m_fieldId = field;
    }

    public void addCase(String value, ForwardLogic forward) {
        this.m_switchMap.put(value.toUpperCase(), forward);
    }

    @Override
    public NextOp createNextOp() {
        return new NextOp(){

            @Override
            public String findNextPage(WizardInteractorData data) {
                String value = null;
                try {
                    value = data.getValue(SwitchForward.this.m_pageId, SwitchForward.this.m_fieldId);
                }
                catch (InteractorDataError e) {
                    DBMTLogger.error(Channel.USER, e.getLocalizedMessage());
                    return null;
                }
                if (value == null) {
                    return null;
                }
                ForwardLogic forwardLogic = (ForwardLogic)SwitchForward.this.m_switchMap.get(value);
                if (forwardLogic == null) {
                    DBMTLogger.info(Channel.DEV, "No forward logic found for value " + value);
                }
                NextOp nextOp = forwardLogic.createNextOp();
                String nextPage = nextOp.findNextPage(data);
                return nextPage;
            }
        };
    }
}

