/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.ProductVersion;
import com.primavera.database.tools.dbmt.ProductId;
import com.primavera.database.tools.dbmt.ProductInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SuiteMap {
    private final Map<ProductSuiteType, Map<ProductVersion, ProductInfo>> m_map = new HashMap<ProductSuiteType, Map<ProductVersion, ProductInfo>>();

    public void addProductInfo(ProductInfo info) {
        Map<ProductVersion, ProductInfo> versionMap = this.m_map.get((Object)info.getSuite());
        if (versionMap == null) {
            versionMap = new HashMap<ProductVersion, ProductInfo>();
            this.m_map.put(info.getSuite(), versionMap);
        }
        versionMap.put(info.getVersion(), info);
    }

    public ProductInfo get(ProductId id) {
        Map<ProductVersion, ProductInfo> versionMap = this.m_map.get((Object)id.getType());
        if (versionMap == null) {
            return null;
        }
        return versionMap.get(id.getVersion());
    }

    public List<ProductInfo> getAvailableSuites(ProductSuiteType type) {
        ArrayList<ProductInfo> list = new ArrayList<ProductInfo>();
        Map<ProductVersion, ProductInfo> versionMap = this.m_map.get((Object)type);
        if (versionMap == null) {
            return list;
        }
        Set<ProductVersion> versionSet = versionMap.keySet();
        Object[] versions = new ProductVersion[versionSet.size()];
        int next = 0;
        for (ProductVersion ver : versionSet) {
            versions[next++] = ver;
        }
        Arrays.sort(versions);
        for (int i = 0; i < versions.length; ++i) {
            list.add(versionMap.get(versions[i]));
        }
        return list;
    }
}

