/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ProductUpgradeVersionMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathException;
import org.xml.sax.SAXException;

public class SchemaUpgradeVersionInfoMap {
    private final Map<SchemaType, ProductUpgradeVersionMap> m_schemaVersionInfoMap = new HashMap<SchemaType, ProductUpgradeVersionMap>();

    private SchemaUpgradeVersionInfoMap(Map<SchemaType, ProductUpgradeVersionMap> map) {
        this.m_schemaVersionInfoMap.putAll(map);
    }

    public ProductUpgradeVersionMap get(SchemaType type) {
        ProductUpgradeVersionMap productUpgradeVersionMap = this.m_schemaVersionInfoMap.get((Object)type);
        DBMTLogger.info(Channel.DEV, "Retrieving upgrade map for schema " + (Object)((Object)type) + "\n" + productUpgradeVersionMap);
        return productUpgradeVersionMap;
    }

    public static SchemaUpgradeVersionInfoMap create(Iterable<SchemaInfo> schemas) throws XPathException, ParserConfigurationException, SAXException, IOException {
        HashMap<SchemaType, ProductUpgradeVersionMap> schemaMap = new HashMap<SchemaType, ProductUpgradeVersionMap>();
        for (SchemaInfo schema : schemas) {
            SchemaType type = schema.getSchemaType();
            ProductUpgradeVersionMap upgradeMap = ProductUpgradeVersionMap.create(schema);
            DBMTLogger.info(Channel.DEV, "Adding upgrade map from schema (" + schema + ") for type " + (Object)((Object)type) + "\n" + upgradeMap);
            schemaMap.put(type, upgradeMap);
        }
        return new SchemaUpgradeVersionInfoMap(schemaMap);
    }
}

