/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.common.StrUtil;
import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.cmd.CommandNotSpecified;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import oracle.jdbc.OracleDriver;

public class PrepScriptRunner {
    private static final String PROPERTY_FILE_LOCATION = ".";
    private static final String PROPERTIES_FILE_NAME = "dbsetup.properties";

    public static void main(String[] args) {
        if (args.length == 0) {
            throw new CommandNotSpecified();
        }
        String readFromFileFlag = args[0];
        if ("-readfromfile".equalsIgnoreCase(readFromFileFlag)) {
            List<String> cmdParamsInPropertiesFile = PrepScriptRunner.loadParameters();
            if (cmdParamsInPropertiesFile == null || cmdParamsInPropertiesFile.size() == 0) {
                DBMTLogger.error("dbsetup.properties is empty!");
                throw new CommandNotSpecified();
            }
            args = cmdParamsInPropertiesFile.toArray(args);
        }
        boolean isUpgrade = false;
        for (String arg : args) {
            if (!arg.toUpperCase().contains("UPGRADE")) continue;
            isUpgrade = true;
            break;
        }
        if (!isUpgrade) {
            return;
        }
        String connectString = PrepScriptRunner.getConnectString(args);
        if (connectString == null) {
            return;
        }
        String adminUser = PrepScriptRunner.getAdminUserString(args);
        ConnectStringParse parse = new ConnectStringParse(connectString);
        boolean oracleService = parse.isOracleService();
        if (oracleService) {
            try {
                DriverManager.registerDriver(new OracleDriver());
                DatabaseConnection c = new DatabaseConnection(connectString);
                String sqlStatement = "GRANT EXECUTE ON sys.DBMS_REPUTIL TO " + adminUser + " WITH GRANT OPTION";
                Statement stmt = c.getConnection().createStatement();
                stmt.execute(sqlStatement);
                sqlStatement = "GRANT SELECT ON sys.DBA_VIEWS TO " + adminUser + " WITH GRANT OPTION";
                stmt.execute(sqlStatement);
                sqlStatement = "GRANT EXECUTE ON sys.DBMS_LOB TO " + adminUser + " WITH GRANT OPTION";
                stmt.execute(sqlStatement);
                sqlStatement = "GRANT EXECUTE ON sys.DBMS_RANDOM TO " + adminUser + " WITH GRANT OPTION";
                stmt.execute(sqlStatement);
                sqlStatement = "GRANT EXECUTE ON sys.DBMS_SQL TO " + adminUser + " WITH GRANT OPTION";
                stmt.execute(sqlStatement);
                sqlStatement = "GRANT EXECUTE ON sys.DBMS_JOB TO " + adminUser + " WITH GRANT OPTION";
                stmt.execute(sqlStatement);
                sqlStatement = "GRANT SELECT ON sys.DBA_EXTENTS TO " + adminUser + " WITH GRANT OPTION";
                stmt.execute(sqlStatement);
                sqlStatement = "GRANT SELECT ON sys.V_$TRANSACTION TO " + adminUser + " WITH GRANT OPTION";
                stmt.execute(sqlStatement);
                sqlStatement = "GRANT SELECT ON sys.GV_$TRANSACTION TO " + adminUser + " WITH GRANT OPTION";
                stmt.execute(sqlStatement);
                stmt.close();
                c.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private static String getConnectString(String[] args) {
        String connection = null;
        boolean nextFieldIsConnection = false;
        for (int i = 0; i < args.length; ++i) {
            if (nextFieldIsConnection) {
                connection = args[i];
                break;
            }
            if (!args[i].equals("-connection")) continue;
            nextFieldIsConnection = true;
        }
        if (connection == null) {
            return null;
        }
        ConnectStringParse parse = new ConnectStringParse(connection);
        boolean oracleService = parse.isOracleService();
        if (oracleService) {
            return "sys:sysdba/" + parse.getPassword() + "@oracle:" + parse.getServer() + ":" + parse.getPort() + "/" + parse.getDatabase();
        }
        return "sys:sysdba/" + parse.getPassword() + "@oracle:" + parse.getServer() + ":" + parse.getPort() + ":" + parse.getDatabase();
    }

    private static String getAdminUserString(String[] args) {
        String connection = null;
        boolean nextFieldIsConnection = false;
        for (int i = 0; i < args.length; ++i) {
            if (nextFieldIsConnection) {
                connection = args[i];
                break;
            }
            if (!args[i].equals("-connection")) continue;
            nextFieldIsConnection = true;
        }
        if (connection == null) {
            return null;
        }
        ConnectStringParse parse = new ConnectStringParse(connection);
        return parse.getUsername();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadParameters() {
        Properties props = new Properties();
        FileInputStream in = null;
        ArrayList<String> cmdParams = new ArrayList<String>();
        try {
            File f = new File(PROPERTY_FILE_LOCATION, PROPERTIES_FILE_NAME);
            in = new FileInputStream(f);
            props.load(in);
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = props.getProperty(key);
                if (StrUtil.isEmpty((String)value)) continue;
                cmdParams.add("-" + key);
                cmdParams.add(value);
            }
            ArrayList<String> arrayList = cmdParams;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            DBMTLogger.error("Could not find the properties file: " + e.getMessage(), e);
        }
        catch (IOException ex) {
            DBMTLogger.error("Could not read the properties file: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
        return null;
    }
}

