/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.ApplicationProperties;
import com.primavera.database.common.PropSet;
import com.primavera.database.common.SchemaInfoImpl;
import com.primavera.database.common.connection.ConnectionUtil;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.Application;
import com.primavera.database.tools.dbmt.ApplicationHelper;
import com.primavera.database.tools.dbmt.ApplicationInitParams;
import com.primavera.database.tools.dbmt.ApplicationRunner;
import com.primavera.database.tools.dbmt.DBMTPropertySets;
import com.primavera.database.tools.dbmt.ExtentionManager;
import com.primavera.database.tools.dbmt.actions.RunnerFactoryManager;
import com.primavera.database.tools.dbmt.util.DevelopmentStringLocalizer;
import com.primavera.database.tools.dbmt.util.DynamicClassFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class Main {
    private static final Collection<File> EMPTY_FILE_COLLECTION = new ArrayList<File>();
    private static final String MAIN_XML_BOOTSTRAP_FILE = "com/primavera/database/tools/dbmt/Core.xml";
    private static final ConnectionUtil.CloseErrorHandler INFORMING_CLOSE_ERROR_HANDLER = new ConnectionUtil.CloseErrorHandler(){

        @Override
        public void handle(SQLException e) throws Exception {
            DBMTLogger.info(Channel.USER, e.getLocalizedMessage());
        }
    };

    public Main() {
        ConnectionUtil.setCloseErrorHandler(INFORMING_CLOSE_ERROR_HANDLER);
    }

    public static void main(String[] args) {
        PropSet[] propSets = new PropSet[DBMTPropertySets.values().length];
        for (int i = 0; i < DBMTPropertySets.values().length; ++i) {
            propSets[i] = DBMTPropertySets.values()[i].getProps();
        }
        try {
            ApplicationInitParams init_params = new ApplicationInitParams();
            init_params.processEnvironment();
            init_params.processProperties(propSets);
            init_params.writeToProperties(ApplicationProperties.getProps());
        }
        catch (ApplicationInitParams.UsageException e) {
            System.err.println("Problem Invoking PDBMS: " + e.getLocalizedMessage());
            Main.printUsageInformation(System.err);
            System.exit(1);
        }
        ApplicationHelper.readApplicationState();
        StringLocalizer.setInstance(new DevelopmentStringLocalizer());
        ExtentionManager.inst().loadExtention(MAIN_XML_BOOTSTRAP_FILE);
        Main.findAndAddSchemaJarsToClassPath(ApplicationHelper.app());
        DynamicClassFactory fact = new DynamicClassFactory();
        try {
            ApplicationRunner runner = (ApplicationRunner)fact.createClassFromName(ApplicationProperties.getProps().getProperty("dbmt.application.runner"));
            Main.configureLogging(runner);
            if (runner == null) {
                DBMTLogger.error(Channel.DEV, "Unable to start app, because the application runner (dbmt.application.runner) could not be found");
                System.exit(1);
            }
            runner.initialize(ApplicationHelper.app());
            runner.processCmdLineParameters(args);
            RunnerFactoryManager.inst().setWizardRunnerFactory(runner.createWizardRunnerFactory());
            RunnerFactoryManager.inst().setDialogRunnerFactory(runner.createDialogRunnerFactory());
            runner.start(ApplicationHelper.app());
        }
        catch (Throwable e) {
            System.err.println("Error : " + e.toString());
            e.printStackTrace();
        }
    }

    private static void configureLogging(ApplicationRunner runner) {
        runner.initializeLogging();
    }

    public static void printUsageInformation(PrintStream out) {
        out.println("TODO: Create Usage Information Message");
    }

    public static void findAndAddSchemaJarsToClassPath(Application app) {
        String schemaJarDirectory = System.getProperty("dbmt.dbschema.package.location", "schemas");
        Collection<File> jarFilesFound = Main.findSchemaJarFiles(schemaJarDirectory);
        for (File jarFile : jarFilesFound) {
            app.addSchemaInfo(jarFile);
        }
    }

    private static Collection<File> findSchemaJarFiles(String location) {
        File directory = new File(location);
        if (!directory.exists()) {
            DBMTLogger.error("Directory " + directory.toString() + " does not exist");
            return EMPTY_FILE_COLLECTION;
        }
        if (!directory.isDirectory()) {
            DBMTLogger.error(directory.toString() + " is not a directory");
            return EMPTY_FILE_COLLECTION;
        }
        String dirPath = directory.getParent();
        try {
            dirPath = directory.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File[] filesInDir = directory.listFiles();
        ArrayList<File> fileSet = new ArrayList<File>();
        for (File f : filesInDir) {
            File file;
            SchemaInfoImpl schemaInfo;
            if (f.isDirectory() || (schemaInfo = SchemaInfoImpl.createFromFile(f)) == null || !(file = new File(dirPath + File.separator + schemaInfo.getFileName())).exists() || file.isDirectory()) continue;
            DBMTLogger.info(Channel.DEV, "Adding Schema Jar File: " + file.getAbsolutePath());
            fileSet.add(file);
        }
        return fileSet;
    }
}

