/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionLogicManager;
import com.primavera.database.tools.dbmt.ActionLogicTreeNode;
import com.primavera.database.tools.dbmt.ActionLogicTreeNodeImpl;
import com.primavera.database.tools.dbmt.ActionOperation;
import com.primavera.database.tools.dbmt.ActionPath;
import com.primavera.database.tools.dbmt.actions.ValueDef;
import java.util.HashMap;
import java.util.Map;

public class ActionLogicManagerImpl
implements ActionLogicManager {
    private static final ActionLogicManager s_inst = new ActionLogicManagerImpl();
    private final ActionLogicTreeNode m_topLevelActionSets = new ActionLogicTreeNodeImpl();
    private final Map<String, Map<String, ValueDef>> m_fieldTemplates = new HashMap<String, Map<String, ValueDef>>();

    public static ActionLogicManager inst() {
        return s_inst;
    }

    @Override
    public ActionOperation findAction(ActionPath path, String name) {
        ActionLogicTreeNode menuItems = this.m_topLevelActionSets;
        for (String actionSetName : path.getPath()) {
            ActionLogicTreeNode nextMap = menuItems.findActionSet(actionSetName);
            if (nextMap == null) {
                return null;
            }
            menuItems = nextMap;
        }
        return menuItems.getActionMap().get(name);
    }

    @Override
    public ActionOperation findAction(String actionPath) {
        String[] parsedPath = actionPath.trim().split("/");
        String actionName = parsedPath[parsedPath.length - 1];
        String[] treePath = new String[parsedPath.length - 1];
        for (int i = 0; i < treePath.length; ++i) {
            treePath[i] = parsedPath[i];
        }
        return this.findAction(new ActionPath(treePath), actionName);
    }

    @Override
    public ActionLogicTreeNode findActionNode(ActionPath path) {
        ActionLogicTreeNode actionItems = this.m_topLevelActionSets;
        for (String actionName : path.getPath()) {
            ActionLogicTreeNode nextMap = actionItems.findActionSet(actionName);
            if (nextMap == null) {
                return null;
            }
            actionItems = nextMap;
        }
        return actionItems;
    }

    @Override
    public ActionLogicTreeNode findActionNode(String path) {
        if (path.trim().equals("")) {
            return this.findActionNode(new ActionPath(new String[0]));
        }
        return this.findActionNode(new ActionPath(path.trim().substring(1).split("/")));
    }

    @Override
    public ActionLogicTreeNode getRoot() {
        return this.m_topLevelActionSets;
    }

    @Override
    public void merge(ActionLogicManager actionMgr) {
        if (actionMgr == null || actionMgr == this) {
            return;
        }
        this.mergeSubTree(this.m_topLevelActionSets, actionMgr.getRoot());
    }

    private void mergeSubTree(ActionLogicTreeNode toTree, ActionLogicTreeNode fromTree) {
        for (Map.Entry<String, ActionOperation> entry : fromTree.getActionMap().entrySet()) {
            toTree.addActionLogic(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : fromTree.getActionSetMap().entrySet()) {
            ActionLogicTreeNode subSet = toTree.findActionSet(entry.getKey());
            if (subSet == null) {
                subSet = toTree.addNode(entry.getKey());
            }
            this.mergeSubTree(subSet, (ActionLogicTreeNode)entry.getValue());
        }
    }

    @Override
    public void addTemplate(String id, Map<String, ValueDef> fieldMap) {
        if (this.m_fieldTemplates.keySet().contains(id)) {
            DBMTLogger.warn(Channel.DEV, "Attempting to add template for id " + id + " but a template is already defined");
        } else {
            this.m_fieldTemplates.put(id, fieldMap);
        }
    }

    @Override
    public Map<String, ValueDef> getTemplate(String id) {
        return this.m_fieldTemplates.get(id);
    }
}

