/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.JobFailedEvent;
import com.primavera.database.common.job.JobFinishedEvent;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobStartingEvent;
import com.primavera.database.common.job.JobThrewExceptionEvent;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.DatabaseToolException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractJob
implements Job {
    private static final List<Job> EMPTY_JOB_LIST = new ArrayList<Job>();
    private static final Set<Job> s_jobsThatHaveRun = new HashSet<Job>();
    private static String failureReason;

    @Override
    public String getMaxVersion() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(JobListener listener, JobWatcher watcher) {
        Set<Job> set = s_jobsThatHaveRun;
        synchronized (set) {
            if (s_jobsThatHaveRun.contains(this)) {
                DBMTLogger.warn(Channel.DEV, "This Job (" + this + ", " + this.hashCode() + ") has already run?");
                return true;
            }
            s_jobsThatHaveRun.add(this);
        }
        try {
            listener.jobStarting(new JobStartingEvent(this), this.isIndeterminateProgress());
            if (this.doJob(listener, watcher)) {
                listener.jobFinished(new JobFinishedEvent(this));
                return true;
            }
            listener.jobFailed(new JobFailedEvent(this));
            return false;
        }
        catch (Throwable e) {
            DBMTLogger.warn(Channel.USER, StringLocalizer.get("dbmt.error.commandline.jobfailed", new String[]{this.toString()}), e);
            listener.jobFailed(new JobThrewExceptionEvent(this, e));
            failureReason = e.getMessage();
            if (e instanceof DatabaseToolException) {
                failureReason = failureReason + StringLocalizer.get("dbmt.upgrade.rollback.failed.sqlQuery", new String[]{this.toString()}) + "\n" + ((DatabaseToolException)e).getSql();
            }
            return false;
        }
    }

    public abstract boolean doJob(JobListener var1, JobWatcher var2) throws Exception;

    @Override
    public List<Job> subjobs() {
        return EMPTY_JOB_LIST;
    }

    @Override
    public String getFailureReason() {
        return failureReason;
    }
}

