/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.value;

public final class DoubleType {
    public static final double DOUBLE_TYPE_TOLERANCE = 1.0E-4;

    private DoubleType() {
    }

    public static boolean EQ(double d2, double d3) {
        return Math.abs(d2 - d3) <= 1.0E-4;
    }

    public static boolean NE(double d2, double d3) {
        return !DoubleType.EQ(d2, d3);
    }

    public static boolean GT(double d2, double d3) {
        return d2 - d3 > 1.0E-4;
    }

    public static boolean LT(double d2, double d3) {
        return DoubleType.GT(d3, d2);
    }

    public static boolean GE(double d2, double d3) {
        return DoubleType.GT(d2, d3) || DoubleType.EQ(d2, d3);
    }

    public static boolean LE(double d2, double d3) {
        return DoubleType.LT(d2, d3) || DoubleType.EQ(d2, d3);
    }

    public static int CMP(double d2, double d3) {
        double d4 = d2 - d3;
        if (d4 > 1.0E-4) {
            return 1;
        }
        if (d4 < -1.0E-4) {
            return -1;
        }
        return 0;
    }

    public static boolean EQ(Number number, Number number2) {
        return DoubleType.EQ(number.doubleValue(), number2.doubleValue());
    }

    public static boolean NE(Number number, Number number2) {
        return DoubleType.NE(number.doubleValue(), number2.doubleValue());
    }

    public static boolean GT(Number number, Number number2) {
        return DoubleType.GT(number.doubleValue(), number2.doubleValue());
    }

    public static boolean LT(Number number, Number number2) {
        return DoubleType.LT(number.doubleValue(), number2.doubleValue());
    }

    public static boolean GE(Number number, Number number2) {
        return DoubleType.GE(number.doubleValue(), number2.doubleValue());
    }

    public static boolean LE(Number number, Number number2) {
        return DoubleType.LE(number.doubleValue(), number2.doubleValue());
    }

    public static int CMP(Number number, Number number2) {
        return DoubleType.CMP(number.doubleValue(), number2.doubleValue());
    }

    public static boolean EQ(Number number, double d2) {
        return DoubleType.EQ(number.doubleValue(), d2);
    }

    public static boolean NE(Number number, double d2) {
        return DoubleType.NE(number.doubleValue(), d2);
    }

    public static boolean GT(Number number, double d2) {
        return DoubleType.GT(number.doubleValue(), d2);
    }

    public static boolean LT(Number number, double d2) {
        return DoubleType.LT(number.doubleValue(), d2);
    }

    public static boolean GE(Number number, double d2) {
        return DoubleType.GE(number.doubleValue(), d2);
    }

    public static boolean LE(Number number, double d2) {
        return DoubleType.LE(number.doubleValue(), d2);
    }

    public static int CMP(Number number, double d2) {
        return DoubleType.CMP(number.doubleValue(), d2);
    }

    public static boolean EQ(double d2, Number number) {
        return DoubleType.EQ(d2, number.doubleValue());
    }

    public static boolean NE(double d2, Number number) {
        return DoubleType.NE(d2, number.doubleValue());
    }

    public static boolean GT(double d2, Number number) {
        return DoubleType.GT(d2, number.doubleValue());
    }

    public static boolean LT(double d2, Number number) {
        return DoubleType.LT(d2, number.doubleValue());
    }

    public static boolean GE(double d2, Number number) {
        return DoubleType.GE(d2, number.doubleValue());
    }

    public static boolean LE(double d2, Number number) {
        return DoubleType.LE(d2, number.doubleValue());
    }

    public static int CMP(double d2, Number number) {
        return DoubleType.CMP(d2, number.doubleValue());
    }
}

