/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.indicators;

import com.primavera.common.indicators.IndicatorInfo;
import com.primavera.common.indicators.UDFIndicatorExpression;
import com.primavera.common.value.DoubleType;
import java.util.Collection;

public class IndicatorExpressionComparator {
    public static IndicatorInfo getIndicatorInfo(Number number, Collection<UDFIndicatorExpression> collection) {
        if (number == null || IndicatorExpressionComparator.isInvalidValue(number)) {
            return new IndicatorInfo();
        }
        int n2 = 0;
        String string = "";
        String string2 = "";
        for (UDFIndicatorExpression uDFIndicatorExpression : collection) {
            if (uDFIndicatorExpression.getIndicatorOperator().equals("eq")) {
                if (!DoubleType.EQ(number, (Number)uDFIndicatorExpression.getIndicatorMinValue())) continue;
                n2 = uDFIndicatorExpression.getIndicatorId();
                string = uDFIndicatorExpression.getIndicatorColor();
                string2 = uDFIndicatorExpression.getIndicatorExpression();
                break;
            }
            if (uDFIndicatorExpression.getIndicatorOperator().equals("neq")) {
                if (!DoubleType.NE(number, (Number)uDFIndicatorExpression.getIndicatorMinValue())) continue;
                n2 = uDFIndicatorExpression.getIndicatorId();
                string = uDFIndicatorExpression.getIndicatorColor();
                string2 = uDFIndicatorExpression.getIndicatorExpression();
                break;
            }
            if (uDFIndicatorExpression.getIndicatorOperator().equals("gt")) {
                if (!DoubleType.GT(number, (Number)uDFIndicatorExpression.getIndicatorMinValue())) continue;
                n2 = uDFIndicatorExpression.getIndicatorId();
                string = uDFIndicatorExpression.getIndicatorColor();
                string2 = uDFIndicatorExpression.getIndicatorExpression();
                break;
            }
            if (uDFIndicatorExpression.getIndicatorOperator().equals("lt")) {
                if (!DoubleType.LT(number, (Number)uDFIndicatorExpression.getIndicatorMinValue())) continue;
                n2 = uDFIndicatorExpression.getIndicatorId();
                string = uDFIndicatorExpression.getIndicatorColor();
                string2 = uDFIndicatorExpression.getIndicatorExpression();
                break;
            }
            if (uDFIndicatorExpression.getIndicatorOperator().equals("le")) {
                if (!DoubleType.LE(number, (Number)uDFIndicatorExpression.getIndicatorMinValue())) continue;
                n2 = uDFIndicatorExpression.getIndicatorId();
                string = uDFIndicatorExpression.getIndicatorColor();
                string2 = uDFIndicatorExpression.getIndicatorExpression();
                break;
            }
            if (uDFIndicatorExpression.getIndicatorOperator().equals("ge")) {
                if (!DoubleType.GE(number, (Number)uDFIndicatorExpression.getIndicatorMinValue())) continue;
                n2 = uDFIndicatorExpression.getIndicatorId();
                string = uDFIndicatorExpression.getIndicatorColor();
                string2 = uDFIndicatorExpression.getIndicatorExpression();
                break;
            }
            if (uDFIndicatorExpression.getIndicatorOperator().equals("btwn")) {
                if (uDFIndicatorExpression.getIndicatorMinValue() == null || uDFIndicatorExpression.getIndicatorMaxValue() == null || !DoubleType.GE(number, (Number)uDFIndicatorExpression.getIndicatorMinValue()) || !DoubleType.LE(number, (Number)uDFIndicatorExpression.getIndicatorMaxValue())) continue;
                n2 = uDFIndicatorExpression.getIndicatorId();
                string = uDFIndicatorExpression.getIndicatorColor();
                string2 = uDFIndicatorExpression.getIndicatorExpression();
                break;
            }
            if (!uDFIndicatorExpression.getIndicatorOperator().equals("nbtwn") || uDFIndicatorExpression.getIndicatorMinValue() == null || uDFIndicatorExpression.getIndicatorMaxValue() == null || !DoubleType.LT(number, (Number)uDFIndicatorExpression.getIndicatorMinValue()) && !DoubleType.GT(number, (Number)uDFIndicatorExpression.getIndicatorMaxValue())) continue;
            n2 = uDFIndicatorExpression.getIndicatorId();
            string = uDFIndicatorExpression.getIndicatorColor();
            string2 = uDFIndicatorExpression.getIndicatorExpression();
            break;
        }
        return new IndicatorInfo(n2, string, string2);
    }

    public static boolean isInvalidValue(Object object) {
        return object instanceof Number && Double.isNaN(((Number)object).doubleValue()) || object instanceof Integer && (Integer)object == Integer.MIN_VALUE;
    }
}

