/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.filterparser;

import com.primavera.common.StrUtil;
import com.primavera.common.bo.DBType;
import com.primavera.common.filterparser.FilterUtil;
import com.primavera.common.filterparser.tree.AbstractTokenizingFilterTreeVisitor;
import com.primavera.common.filterparser.tree.BinaryStatement;
import com.primavera.common.filterparser.tree.FilterTreeNode;
import com.primavera.common.filterparser.tree.FunctionStatement;
import com.primavera.common.filterparser.tree.InvalidTreeException;
import com.primavera.common.filterparser.tree.IsUnderSQLGenerator;
import com.primavera.common.filterparser.tree.Statement;
import com.primavera.common.util.SQLStatementUtil;
import java.util.Locale;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DeprecationFilterTreeVisitor
extends AbstractTokenizingFilterTreeVisitor {
    public DeprecationFilterTreeVisitor() {
        super(DBType.Uninitialized);
    }

    @Override
    public void visit(FilterTreeNode filterTreeNode) throws InvalidTreeException {
        if (!DeprecationFilterTreeVisitor.a(filterTreeNode)) {
            return;
        }
        super.visit(filterTreeNode);
    }

    @Override
    public void afterDescend(FilterTreeNode filterTreeNode) {
        if (this.if(filterTreeNode)) {
            super.afterDescend(filterTreeNode);
        }
    }

    private boolean if(FilterTreeNode filterTreeNode) {
        for (FilterTreeNode filterTreeNode2 : filterTreeNode.getChildren()) {
            if (filterTreeNode2.isGroup() && this.if(filterTreeNode2)) {
                return true;
            }
            if (!DeprecationFilterTreeVisitor.a(filterTreeNode2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void beforeDescend(FilterTreeNode filterTreeNode) {
        if (this.if(filterTreeNode)) {
            super.beforeDescend(filterTreeNode);
        }
    }

    @Override
    protected String a(Statement statement) {
        BinaryStatement binaryStatement = null;
        if (statement instanceof FunctionStatement) {
            IsUnderSQLGenerator.FieldInfo fieldInfo = IsUnderSQLGenerator.getFieldInfo((FunctionStatement)statement);
            binaryStatement = new BinaryStatement(FilterUtil.unudfize(fieldInfo.logicalFilterFieldName), Statement.parsePredicate("ISUNDER"), fieldInfo.filterValue, null);
        } else if (statement instanceof BinaryStatement) {
            binaryStatement = (BinaryStatement)statement;
        }
        if (binaryStatement != null) {
            return DeprecationFilterTreeVisitor.a(binaryStatement.getLeft(), binaryStatement.getPredicate().toString(), binaryStatement.getRight(), null);
        }
        return statement.toString();
    }

    private static boolean a(FilterTreeNode filterTreeNode) {
        if (filterTreeNode != null) {
            if (filterTreeNode.getType() != null && filterTreeNode.getStatement() == null) {
                if (!filterTreeNode.getChildren().isEmpty()) {
                    for (FilterTreeNode filterTreeNode2 : filterTreeNode.getChildren()) {
                        if (!DeprecationFilterTreeVisitor.a(filterTreeNode2)) continue;
                        return true;
                    }
                }
            } else if (filterTreeNode.getStatement() != null) {
                Statement statement = filterTreeNode.getStatement();
                if (statement instanceof BinaryStatement) {
                    boolean bl;
                    BinaryStatement binaryStatement = (BinaryStatement)statement;
                    boolean bl2 = bl = !StrUtil.isEmpty(binaryStatement.getLeft());
                    if (bl) {
                        boolean bl3 = bl = binaryStatement.getPredicate() != null;
                        if (bl) {
                            bl = binaryStatement.getPredicate().toString().startsWith("IS") && binaryStatement.getRight() == null || !StrUtil.isEmpty(binaryStatement.getRight());
                        }
                    }
                    return bl;
                }
                return false;
            }
        }
        return false;
    }

    private static String a(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder(64);
        string = FilterUtil.udfize(string);
        if ("BETWEEN".equalsIgnoreCase(string2)) {
            stringBuilder.append(string);
            stringBuilder.append(" BETWEEN ");
            stringBuilder.append(string3);
            stringBuilder.append(" AND ");
            stringBuilder.append(string4);
        } else if ("NOT BETWEEN".equalsIgnoreCase(string2)) {
            stringBuilder.append(string);
            stringBuilder.append(" NOT BETWEEN ");
            stringBuilder.append(string3);
            stringBuilder.append(" AND ");
            stringBuilder.append(string4);
        } else if (string2.indexOf("LIKE") != -1) {
            stringBuilder.append(string);
            if ("LIKE".equals(string2) || "NOT LIKE".equals(string2)) {
                string2 = string2 + " " + FilterUtil.inferLikeMask(string3);
            }
            string3 = SQLStatementUtil.escapeStringForLike(string3, DBType.Uninitialized);
            String string5 = string2.contains("$") ? StrUtil.searchAndReplace(string2, "$", string3, Locale.ENGLISH, false, true) : string2 + string3;
            stringBuilder.append(' ').append(string5).append(')');
        } else if ("IS NOT".equals(string2) || "IS".equals(string2)) {
            stringBuilder.append(string).append(' ').append(string2).append(' ').append(String.valueOf(string3).toUpperCase());
        } else {
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }
}

