/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.db;

import java.text.MessageFormat;

public class DatabaseURLBuilder {
    public static final String ORACLE_THIN_SSL_URL_FORMAT = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=tcps)(HOST={0})(PORT={1}))(CONNECT_DATA=(SERVICE_NAME={2})))";
    public static final String ORACLE_OCI_SSL_URL_FORMAT = "jdbc:oracle:oci:@(DESCRIPTION=(ADDRESS=(PROTOCOL=tcps)(HOST={0})(PORT={1}))(CONNECT_DATA=(SERVICE_NAME={2})))";
    public static final String ORACLE_THIN_SID_URL_FORMAT = "jdbc:oracle:thin:@{0}:{1}:{2}";
    public static final String ORACLE_THIN_SERVICE_URL_FORMAT = "jdbc:oracle:thin:@{0}:{1}/{2}";
    public static final String ORACLE_ATP_THIN_SERVICE_URL_FORMAT = "jdbc:oracle:thin:@{0}?TNS_ADMIN={1}";
    public static final String ORACLE_OCI_SID_URL_FORMAT = "jdbc:oracle:oci:@{0}:{1}:{2}";
    public static final String ORACLE_OCI_SERVICE_URL_FORMAT = "jdbc:oracle:oci:@{0}:{1}/{2}";
    public static final String SQLSERVER_URL_FORMAT = "jdbc:sqlserver://{0}:{1};database={2};";

    private DatabaseURLBuilder() {
    }

    public static String getOracleThinURL(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (bl2) {
            return MessageFormat.format(ORACLE_THIN_SSL_URL_FORMAT, string, string2, string3);
        }
        if (bl) {
            return MessageFormat.format(ORACLE_THIN_SERVICE_URL_FORMAT, string, string2, string3);
        }
        return MessageFormat.format(ORACLE_THIN_SID_URL_FORMAT, string, string2, string3);
    }

    public static String getOracleATPThinURL(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (bl2) {
            return MessageFormat.format(ORACLE_THIN_SSL_URL_FORMAT, string, string2, string3);
        }
        if (bl) {
            return MessageFormat.format(ORACLE_ATP_THIN_SERVICE_URL_FORMAT, string3, string);
        }
        return MessageFormat.format(ORACLE_ATP_THIN_SERVICE_URL_FORMAT, string3, string);
    }

    public static String getOracleOciURL(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (bl) {
            return MessageFormat.format(ORACLE_OCI_SSL_URL_FORMAT, string, string2, string3);
        }
        if (bl2) {
            return MessageFormat.format(ORACLE_OCI_SERVICE_URL_FORMAT, string, string2, string3);
        }
        return MessageFormat.format(ORACLE_OCI_SID_URL_FORMAT, string, string2, string3);
    }

    public static String getSqlServerURL(String string, String string2, String string3, boolean bl) {
        String string4 = MessageFormat.format(SQLSERVER_URL_FORMAT, string, string2, string3);
        if (bl) {
            string4 = string4 + "encrypt=true;trustServerCertificate=true;";
        }
        return string4;
    }
}

