/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.ScriptRunner;

import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.ScriptRunner.ScriptProperties;
import com.primavera.database.tools.ScriptRunner.StatementChangeType;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ScriptStatement {
    private final String START_TOKEN = "${";
    private final String END_TOKEN = "}";
    private final ArrayList<String> statement = new ArrayList();
    private int lineCount = 0;
    private String objectName;
    private String objectType;
    private String tableName;
    private StatementChangeType changeType;
    private ScriptProperties properties;
    private String rawSQL = "";
    private String lastSQL;
    private String metaDataString;

    public StatementChangeType getChangeType() {
        return this.changeType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public ScriptProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ScriptProperties properties) {
        this.properties = properties;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void add(String sline) {
        this.statement.add(sline);
        ++this.lineCount;
        this.rawSQL = this.rawSQL + " " + sline;
    }

    public int getCount() {
        return this.lineCount;
    }

    public ArrayList<String> getStatement() {
        return this.statement;
    }

    public String getString() throws DatabaseToolException {
        String stmt = "";
        for (String string : this.statement) {
            stmt = stmt + " " + this.parameterize(string);
        }
        this.lastSQL = stmt;
        return stmt.trim();
    }

    private String parameterize(String rawstring) throws DatabaseToolException {
        int pos;
        String newstring = rawstring;
        String returnstring = rawstring;
        int lastpos = 0;
        while ((pos = newstring.indexOf("${", lastpos)) != -1) {
            lastpos = pos + 1;
            int endpos = newstring.indexOf("}", lastpos);
            if (endpos < 0) continue;
            String token = newstring.substring(pos + 2, endpos);
            String replacement = this.properties.getProperty(token);
            if (replacement == null) {
                throw new DatabaseToolException("Token not replaced: ${" + token + "}");
            }
            returnstring = returnstring.replace("${" + token + "}", replacement);
        }
        return returnstring;
    }

    public void setMetadata(String metastring) {
        this.metaDataString = metastring;
        StringTokenizer st = new StringTokenizer(metastring);
        this.changeType = StatementChangeType.UNKNOWN;
        this.objectName = "";
        this.tableName = "";
        this.objectType = "";
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            StringTokenizer pair = new StringTokenizer(tok, ":");
            String name = pair.nextToken();
            if (name.compareToIgnoreCase("NAME") == 0) {
                this.objectName = pair.nextToken();
                continue;
            }
            if (name.compareToIgnoreCase("TYPE") == 0) {
                this.objectType = pair.nextToken();
                continue;
            }
            if (name.compareToIgnoreCase("TABLE_NAME") == 0) {
                this.tableName = pair.nextToken();
                continue;
            }
            if (name.compareToIgnoreCase("CHANGE") != 0) continue;
            String change = pair.nextToken();
            if (change.compareToIgnoreCase("CREATE") == 0) {
                this.changeType = StatementChangeType.CREATE;
                continue;
            }
            if (change.compareToIgnoreCase("ALTER") == 0) {
                this.changeType = StatementChangeType.ALTER;
                continue;
            }
            if (change.compareToIgnoreCase("DROP") != 0) continue;
            this.changeType = StatementChangeType.DROP;
        }
        if (this.objectType.compareToIgnoreCase("TABLE") == 0) {
            this.tableName = this.objectName;
        }
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void clear() {
        this.statement.clear();
        this.objectName = null;
        this.objectType = null;
        this.lineCount = 0;
        this.tableName = null;
        this.changeType = null;
        this.rawSQL = "";
        this.lastSQL = "";
    }

    public String getLastSQL() {
        return this.lastSQL.trim();
    }

    public String getRawSQL() {
        return this.rawSQL.trim();
    }

    public String getMetaDataString() {
        return this.metaDataString;
    }
}

