/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.ScriptRunner;

import com.primavera.database.common.DatabaseHelper;
import com.primavera.database.common.ServerType;
import com.primavera.database.tools.ScriptRunner.StatementChangeType;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ErrorValidation {
    static Map<String, Boolean> errorMap = new HashMap<String, Boolean>();

    public static String statementChangeTypeToString(StatementChangeType type) {
        switch (type) {
            case ALTER: {
                return "alter";
            }
            case DROP: {
                return "drop";
            }
            case CREATE: {
                return "create";
            }
        }
        return "other";
    }

    public static String formatCheckString(ServerType serverType, String objectType, StatementChangeType type, int error) {
        return DatabaseHelper.ServerTypeToString(serverType) + ":" + objectType + ":" + ErrorValidation.statementChangeTypeToString(type).toLowerCase() + ":" + String.valueOf(error);
    }

    public static boolean acceptable(ServerType serverType, String objectType, StatementChangeType type, int error) {
        String check = ErrorValidation.formatCheckString(serverType, objectType, type, error).toLowerCase();
        Boolean b = errorMap.get(check);
        if (b == null) {
            return false;
        }
        return b;
    }

    private static Map<String, Boolean> createErrorValidationMap() throws XPathException, ParserConfigurationException, SAXException, IOException {
        HashMap<String, Boolean> errorMap = new HashMap<String, Boolean>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath path = factory.newXPath();
        String xpString = "/ignore/error";
        XPathExpression xpExpr = path.compile(xpString);
        DocumentBuilderFactory domfactory = DocumentBuilderFactory.newInstance();
        domfactory.setNamespaceAware(true);
        DocumentBuilder builder = domfactory.newDocumentBuilder();
        Document doc = builder.parse(ErrorValidation.getErrorValidationXML());
        NodeList result = (NodeList)xpExpr.evaluate(doc, XPathConstants.NODESET);
        int length = result.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = result.item(i);
            String errorId = node.getAttributes().getNamedItem("id").toString();
            System.out.print("ID = " + errorId);
            errorMap.put(errorId, Boolean.TRUE);
        }
        return errorMap;
    }

    private static InputStream getErrorValidationXML() {
        String inputSource = System.getProperty("dbmt.error.validation.map", "/com/primavera/database/tools/ScriptRunner/ErrorValidation.xml");
        ClassLoader.getSystemResource(inputSource);
        return ClassLoader.getSystemResourceAsStream(inputSource);
    }

    static {
        errorMap.put("or:table:create:955", Boolean.TRUE);
        errorMap.put("or:table:drop:942", Boolean.TRUE);
        errorMap.put("or:index:create:955", Boolean.TRUE);
        errorMap.put("or:procedure:drop:4043", Boolean.TRUE);
        errorMap.put("or:trigger:drop:4080", Boolean.TRUE);
        errorMap.put("or:index:drop:1418", Boolean.TRUE);
        errorMap.put("or:view:drop:942", Boolean.TRUE);
        errorMap.put("or:user:create:1920", Boolean.TRUE);
        errorMap.put("or:constraint:create:2260", Boolean.TRUE);
        errorMap.put("or:constraint:create:2261", Boolean.TRUE);
        errorMap.put("or:constraint:create:2275", Boolean.TRUE);
        errorMap.put("or:constraint:create:2264", Boolean.TRUE);
        errorMap.put("or:synonym:create:955", Boolean.TRUE);
        errorMap.put("or:link:create:2011", Boolean.TRUE);
        errorMap.put("or:field:drop:904", Boolean.TRUE);
        errorMap.put("ss:table:create:2714", Boolean.TRUE);
        errorMap.put("ss:index:create:1913", Boolean.TRUE);
        errorMap.put("ss:view:create:2714", Boolean.TRUE);
        errorMap.put("ss:procedure:create:2714", Boolean.TRUE);
        errorMap.put("ss:function:create:2714", Boolean.TRUE);
        errorMap.put("ss:trigger:create:2714", Boolean.TRUE);
        errorMap.put("ss:constraint:create:2714", Boolean.TRUE);
        errorMap.put("ss:table:drop:3701", Boolean.TRUE);
        errorMap.put("ss:trigger:drop:3701", Boolean.TRUE);
        errorMap.put("ss:procedure:drop:3701", Boolean.TRUE);
        errorMap.put("ss:function:drop:3701", Boolean.TRUE);
        errorMap.put("ss:index:drop:3701", Boolean.TRUE);
        errorMap.put("ss:view:drop:3701", Boolean.TRUE);
        errorMap.put("ss:user:create:15023", Boolean.TRUE);
        errorMap.put("asa:table:create:12006", Boolean.TRUE);
        errorMap.put("asa:index:create:1921", Boolean.TRUE);
        errorMap.put("asa:view:create:12006", Boolean.TRUE);
        errorMap.put("asa:procedure:create:12006", Boolean.TRUE);
        errorMap.put("asa:function:create:12006", Boolean.TRUE);
        errorMap.put("asa:trigger:create:102", Boolean.TRUE);
        errorMap.put("asa:table:drop:2706", Boolean.TRUE);
        errorMap.put("asa:trigger:drop:9819", Boolean.TRUE);
        errorMap.put("asa:procedure:drop:504", Boolean.TRUE);
        errorMap.put("asa:function:drop:504", Boolean.TRUE);
        errorMap.put("asa:index:drop:6226", Boolean.TRUE);
        errorMap.put("asa:view:drop:2706", Boolean.TRUE);
    }
}

