/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.SchemaValidation;

import com.primavera.database.common.DatabaseHelper;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.connection.DatabaseMetaData;
import com.primavera.database.common.connection.IDatabaseMetaData;
import com.primavera.database.common.dbo.DatabaseColumn;
import com.primavera.database.common.dbo.DatabaseConstraint;
import com.primavera.database.common.dbo.DatabaseIndex;
import com.primavera.database.common.dbo.DatabasePrivilege;
import com.primavera.database.common.dbo.DatabaseProcedure;
import com.primavera.database.common.dbo.DatabaseSynonym;
import com.primavera.database.common.dbo.DatabaseTable;
import com.primavera.database.common.dbo.DatabaseTrigger;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.SchemaValidation.SchemaBuilderEvent;
import com.primavera.database.tools.SchemaValidation.SchemaBuilderListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaBuilder {
    private final IDatabaseMetaData metaData;
    private final Document xmldoc = this.getNewDocument();
    private String databaseVersion = new String();
    private String databaseType = new String();
    private int m_tablecount = 0;
    private int m_tableprocessed = 0;
    ArrayList<SchemaBuilderListener> listeners = new ArrayList();

    public SchemaBuilder(IDatabaseMetaData metadata) {
        this.metaData = metadata;
    }

    public void generate() throws SQLException {
        Element root = this.xmldoc.createElement("PrimaveraDatabaseSchema");
        root.setAttribute("VERSION", this.databaseVersion);
        root.setAttribute("DBTYPE", this.databaseType);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        root.setAttribute("RUNDATE", dateFormat.format(new Date()));
        ArrayList<DatabaseTable> tables = this.metaData.getTables();
        this.m_tablecount = tables.size();
        this.sendSchemaBuilderBegin(this.m_tablecount);
        ListIterator<DatabaseTable> iter = tables.listIterator();
        while (iter.hasNext()) {
            DatabaseTable table = iter.next();
            this.sendTableBegin(table.getName());
            Element tableElem = this.xmldoc.createElement("TABLE");
            tableElem.setAttribute("NAME", table.getName());
            tableElem.setAttribute("TABLETYPE", table.getTableType());
            root.appendChild(tableElem);
            ArrayList<DatabaseColumn> columns = this.metaData.getColumns(table.getName());
            ListIterator<DatabaseColumn> citer = columns.listIterator();
            while (citer.hasNext()) {
                DatabaseColumn column = citer.next();
                Element columnElem = this.xmldoc.createElement("FIELD");
                columnElem.setAttribute("TABLE", column.getTableName().trim());
                columnElem.setAttribute("NAME", column.getName().trim());
                columnElem.setAttribute("DATATYPE", column.getGenericDataType().trim());
                columnElem.setAttribute("CHARLENGTH", String.valueOf(column.getLength()).trim());
                if (column.getDataType().equalsIgnoreCase("VARCHAR2") || column.getDataType().equalsIgnoreCase("VARCHAR") || column.getDataType().equalsIgnoreCase("NVARCHAR")) {
                    columnElem.setAttribute("DATAPRECISION", "");
                    columnElem.setAttribute("DATASCALE", "");
                } else {
                    columnElem.setAttribute("DATAPRECISION", String.valueOf(column.getPrecision()).trim());
                    columnElem.setAttribute("DATASCALE", String.valueOf(column.getScale()).trim());
                }
                columnElem.setAttribute("NOTNULL", column.getNotNullFlag().trim());
                if (column.getDefaultValue().contains("(")) {
                    columnElem.setAttribute("DEFAULT", column.getDefaultValue().replace("(", "").replace(")", "").trim());
                } else {
                    columnElem.setAttribute("DEFAULT", column.getDefaultValue().trim());
                }
                tableElem.appendChild(columnElem);
            }
            ArrayList<DatabaseTrigger> triggers = this.metaData.getTriggers(table.getName());
            ListIterator<DatabaseTrigger> tli = triggers.listIterator();
            while (tli.hasNext()) {
                DatabaseTrigger trig = tli.next();
                Element triggerElem = this.xmldoc.createElement("TRIGGER");
                triggerElem.setAttribute("NAME", trig.getName());
                triggerElem.setAttribute("TABLE", trig.getTableName());
                tableElem.appendChild(triggerElem);
            }
            ArrayList<DatabaseIndex> indexes = this.metaData.getIndexes(table.getName());
            ListIterator<DatabaseIndex> ili = indexes.listIterator();
            while (ili.hasNext()) {
                DatabaseIndex index = ili.next();
                Element indexElem = this.xmldoc.createElement("INDEX");
                indexElem.setAttribute("NAME", index.getName());
                indexElem.setAttribute("TABLE", index.getTableName());
                indexElem.setAttribute("UNIQUENESS", index.getUniqueText());
                indexElem.setAttribute("FIELD", index.getFieldList());
                tableElem.appendChild(indexElem);
            }
            DatabaseConstraint primary = this.metaData.getPrimary(table.getName());
            ArrayList<DatabaseConstraint> cons = this.metaData.getForeign(table.getName());
            cons.addAll(this.metaData.getCheck(table.getName()));
            if (primary.getName() != null) {
                cons.add(primary);
            }
            ListIterator<DatabaseConstraint> cli = cons.listIterator();
            while (cli.hasNext()) {
                DatabaseConstraint constraint = cli.next();
                Element consElem = this.xmldoc.createElement("CONSTRAINT");
                consElem.setAttribute("TABLE", table.getName());
                consElem.setAttribute("NAME", constraint.getName());
                consElem.setAttribute("TYPE", constraint.getType());
                consElem.setAttribute("FIELDS", constraint.getFieldList());
                consElem.setAttribute("TARGETTABLE", constraint.getTargetTableName());
                consElem.setAttribute("TARGETFIELDS", constraint.getTargetFieldList());
                consElem.setAttribute("SEARCHCONDITION", constraint.getSearchCondition());
                tableElem.appendChild(consElem);
            }
            ArrayList<DatabasePrivilege> privs = this.metaData.getPrivs(table.getName());
            ListIterator<DatabasePrivilege> piter = privs.listIterator();
            while (piter.hasNext()) {
                DatabasePrivilege priv = piter.next();
                Element privElem = this.xmldoc.createElement("GRANTS");
                privElem.setAttribute("PRIVILEGES", priv.getPrivileges());
                privElem.setAttribute("GRANTEE", priv.getGrantee());
                tableElem.appendChild(privElem);
            }
            ArrayList<DatabaseSynonym> syns = this.metaData.getSynonyms(table.getName());
            ListIterator<DatabaseSynonym> siter = syns.listIterator();
            while (siter.hasNext()) {
                DatabaseSynonym syn = siter.next();
                Element synElem = this.xmldoc.createElement("SYNONYM");
                synElem.setAttribute("TYPE", syn.getType());
                synElem.setAttribute("OWNER", syn.getOwner());
                tableElem.appendChild(synElem);
            }
            this.sendTableComplete(table.getName());
        }
        ArrayList<String> views = this.metaData.getViews();
        ListIterator<String> viter = views.listIterator();
        while (viter.hasNext()) {
            String view = viter.next();
            Element viewElem = this.xmldoc.createElement("VIEW");
            viewElem.setAttribute("NAME", view);
            ArrayList<DatabasePrivilege> privs = this.metaData.getPrivs(view);
            ListIterator<DatabasePrivilege> citer = privs.listIterator();
            while (citer.hasNext()) {
                DatabasePrivilege priv = citer.next();
                Element privElem = this.xmldoc.createElement("GRANTS");
                privElem.setAttribute("PRIVILEGES", priv.getPrivileges());
                privElem.setAttribute("GRANTEE", priv.getGrantee());
                viewElem.appendChild(privElem);
            }
            ArrayList<DatabaseSynonym> syns = this.metaData.getSynonyms(view);
            ListIterator<DatabaseSynonym> siter = syns.listIterator();
            while (siter.hasNext()) {
                DatabaseSynonym syn = siter.next();
                Element synElem = this.xmldoc.createElement("SYNONYM");
                synElem.setAttribute("TYPE", syn.getType());
                synElem.setAttribute("OWNER", syn.getOwner());
                viewElem.appendChild(synElem);
            }
            root.appendChild(viewElem);
        }
        ArrayList<DatabaseProcedure> procs = this.metaData.getProcedures();
        ListIterator<DatabaseProcedure> piter = procs.listIterator();
        while (piter.hasNext()) {
            DatabaseProcedure proc = piter.next();
            Element procElem = this.xmldoc.createElement("PROCEDURE");
            procElem.setAttribute("NAME", proc.getName());
            procElem.setAttribute("TYPE", proc.getType());
            ArrayList<DatabasePrivilege> privs = this.metaData.getProcedurePrivs(proc.getName());
            ListIterator<DatabasePrivilege> citer = privs.listIterator();
            while (citer.hasNext()) {
                DatabasePrivilege priv = citer.next();
                Element privElem = this.xmldoc.createElement("GRANTS");
                privElem.setAttribute("PRIVILEGES", priv.getPrivileges());
                privElem.setAttribute("GRANTEE", priv.getGrantee());
                procElem.appendChild(privElem);
            }
            ArrayList<DatabaseSynonym> syns = this.metaData.getSynonyms(proc.getName());
            ListIterator<DatabaseSynonym> siter = syns.listIterator();
            while (siter.hasNext()) {
                DatabaseSynonym syn = siter.next();
                Element synElem = this.xmldoc.createElement("SYNONYM");
                synElem.setAttribute("TYPE", syn.getType());
                synElem.setAttribute("OWNER", syn.getOwner());
                procElem.appendChild(synElem);
            }
            root.appendChild(procElem);
        }
        this.xmldoc.appendChild(root);
        this.sendSchemaBuilderComplete();
    }

    public void output(OutputStream out) throws IOException {
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(this.xmldoc), new StreamResult(out));
        }
        catch (TransformerException | TransformerFactoryConfigurationError e) {
            out.write(e.getMessage().getBytes());
        }
    }

    public static void main(String[] args) throws SQLException, IOException, DatabaseToolException {
        DatabaseConnection conn = new DatabaseConnection("admuser/admuser@oracle:psapre-lap:1521:orcl");
        DatabaseMetaData meta = new DatabaseMetaData();
        meta.setDatabaseConnection(conn);
        SchemaBuilder sb = new SchemaBuilder(meta);
        sb.setSchemaString(DatabaseHelper.getSchemaVersionString(conn.getConnection()));
        sb.generate();
        sb.output(System.out);
        sb.output(new FileOutputStream(new File("c:\\temp\\ss_pmitval.xml")));
        conn.close();
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public void setDatabaseVersion(String databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public void setSchemaString(String schemastring) throws DatabaseToolException {
        if (schemastring.startsWith("PMDB") || schemastring.startsWith("MMDB")) {
            String[] version = schemastring.split(",");
            if (version.length < 2) {
                throw new DatabaseToolException("Invalid database schema string: " + schemastring);
            }
            this.databaseType = version[0];
            this.databaseVersion = version[1];
        }
    }

    public Document getSchemaDocument() {
        return this.xmldoc;
    }

    public Document getDocument() {
        return this.xmldoc;
    }

    public void addListener(SchemaBuilderListener listener) {
        this.listeners.add(listener);
    }

    private void sendSchemaBuilderBegin(int table_count) {
        this.m_tablecount = table_count;
        this.m_tableprocessed = 0;
        SchemaBuilderEvent event = new SchemaBuilderEvent(this);
        event.setTotalTables(this.m_tablecount);
        event.setProcessedTables(0);
        Iterator<SchemaBuilderListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            SchemaBuilderListener element;
            SchemaBuilderListener sl = element = iterator.next();
            sl.schemaBuilderBegin(event);
        }
    }

    private void sendSchemaBuilderComplete() {
        this.m_tableprocessed = this.m_tablecount;
        SchemaBuilderEvent event = new SchemaBuilderEvent(this);
        event.setTotalTables(this.m_tablecount);
        event.setProcessedTables(this.m_tableprocessed);
        Iterator<SchemaBuilderListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            SchemaBuilderListener element;
            SchemaBuilderListener sl = element = iterator.next();
            sl.schemaBuilderComplete(event);
        }
    }

    public void sendTableBegin(String tablename) {
        SchemaBuilderEvent event = new SchemaBuilderEvent(this);
        event.setTotalTables(this.m_tablecount);
        event.setProcessedTables(this.m_tableprocessed);
        event.setTableName(tablename);
        Iterator<SchemaBuilderListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            SchemaBuilderListener element;
            SchemaBuilderListener sl = element = iterator.next();
            sl.tableBegin(event);
        }
    }

    public void sendTableComplete(String tablename) {
        ++this.m_tableprocessed;
        SchemaBuilderEvent event = new SchemaBuilderEvent(this);
        event.setTotalTables(this.m_tablecount);
        event.setProcessedTables(this.m_tableprocessed);
        event.setTableName(tablename);
        Iterator<SchemaBuilderListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            SchemaBuilderListener element;
            SchemaBuilderListener sl = element = iterator.next();
            sl.tableComplete(event);
        }
    }

    public void toFile(String filename) throws DatabaseToolException {
        DOMSource source = new DOMSource(this.getDocument());
        File f = new File(filename);
        try {
            FileOutputStream out = new FileOutputStream(f);
            StreamResult result = new StreamResult(out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer serializer = factory.newTransformer();
            serializer.setOutputProperty("encoding", "ISO-8859-1");
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(source, result);
        }
        catch (Exception e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
    }

    private Document getNewDocument() {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return doc;
    }
}

