/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class GenerateScriptPropertyIDs {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Exactly 2 argument requireds, but " + args.length + " provided");
            System.err.println("Syntax: " + GenerateScriptPropertyIDs.class.getSimpleName() + " <source_root_directory> <qualified_class_name>");
            System.exit(1);
        }
        InputStream input = ClassLoader.getSystemClassLoader().getResourceAsStream("com/primavera/database/tools/ScriptRunner/core_script.properties");
        Properties defaultProperties = new Properties();
        try {
            defaultProperties.load(input);
        }
        catch (IOException e) {
            System.err.println("Error generating properties file" + e);
            System.exit(1);
        }
        File outputFile = GenerateScriptPropertyIDs.createFileName(args[0], args[1]);
        HashSet<String> assignments = new HashSet<String>();
        for (Object o : defaultProperties.keySet()) {
            assignments.add(GenerateScriptPropertyIDs.createAssignmentFromId(o.toString()));
        }
        try {
            GenerateScriptPropertyIDs.writePropertyDefs(args[1], outputFile, assignments);
        }
        catch (Exception e) {
            System.err.println("Error creating output file" + e);
            e.toString();
            System.exit(1);
        }
    }

    private static File createFileName(String rootDirName, String pkgName) {
        File rootDir = new File(rootDirName);
        int lastDot = pkgName.lastIndexOf(".");
        String fileName = pkgName + ".java";
        String pkgDirSuffix = File.separator;
        if (lastDot >= 0) {
            pkgDirSuffix = "/" + pkgName.substring(0, lastDot).replace(".", File.separator);
            fileName = pkgName.substring(lastDot + 1) + ".java";
        }
        File newFile = new File(rootDir + pkgDirSuffix + File.separator + fileName);
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePropertyDefs(String qualifiedClassName, File outputFile, Set<String> assignments) throws Exception {
        outputFile.createNewFile();
        String packageDeclaration = null;
        String className = qualifiedClassName;
        int lastDot = qualifiedClassName.lastIndexOf(".");
        if (lastDot >= 0) {
            if (lastDot == qualifiedClassName.length() - 1) {
                throw new Exception("Invalid qualified class name" + qualifiedClassName);
            }
            packageDeclaration = qualifiedClassName.substring(0, lastDot);
            className = qualifiedClassName.substring(lastDot + 1);
        }
        System.out.println("Attempting to create file " + outputFile.getName());
        try (PrintStream output = new PrintStream(new FileOutputStream(outputFile, false));){
            GenerateScriptPropertyIDs.writeJavaFile(output, packageDeclaration, className, assignments);
        }
    }

    private static void writeJavaFile(PrintStream output, String packageDeclaration, String className, Set<String> assignments) {
        if (packageDeclaration != null) {
            output.println("package " + packageDeclaration + ";");
            output.println();
        }
        output.println("public interface " + className);
        output.println("{");
        for (String assignment : assignments) {
            output.println("  " + assignment + ";");
        }
        output.println("}");
    }

    private static String createAssignmentFromId(String string) {
        String javaId = GenerateScriptPropertyIDs.getJavaIdFromPropName(string);
        return "public static final String " + javaId + " = \"" + string + "\"";
    }

    private static String getJavaIdFromPropName(String string) {
        return string.toUpperCase().replace(' ', '_').replace('.', '_');
    }
}

