/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader.output;

import com.primavera.database.PrimaveraDatabaseException;
import com.primavera.database.common.Base64;
import com.primavera.database.common.GenericDataTypes;
import com.primavera.database.common.container.RowContainer;
import com.primavera.database.common.container.RowElement;
import com.primavera.database.common.container.SQLRowContainer;
import com.primavera.database.common.container.XMLRowGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Iterator;

public class XMLOutputter {
    public final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><DATAPACKET Version=\"2.0\"><METADATA><FIELDS>";
    public final String XML_CLOSE_FIELDS = "</FIELDS><PARAMS/></METADATA><ROWDATA>";
    public final String XML_END = "</ROWDATA></DATAPACKET>";

    private String getDelphiFieldType(GenericDataTypes type, int len) {
        switch (type) {
            case SMALLINT: 
            case TINYINT: 
            case INTEGER: {
                return "fieldtype=\"i4\"";
            }
            case DATE: {
                return "fieldtype=\"SQLdateTime\" SUBTYPE=\"Formatted\"";
            }
            case DOUBLE: 
            case NUMBER: {
                return "fieldtype=\"r8\"";
            }
            case MEMO: 
            case CLOB: {
                return "fieldtype=\"bin.hex\" SUBTYPE=\"Text\"";
            }
            case XMLTYPE: {
                return "fieldtype=\"bin.hex\" SUBTYPE=\"Xml\"";
            }
            case IMAGE: 
            case BLOB: {
                return "fieldtype=\"bin.hex\" SUBTYPE=\"Binary\" WIDTH=\"1\"";
            }
        }
        return "fieldtype=\"string\" WIDTH=\"" + String.valueOf(len) + "\"";
    }

    private String fieldText(RowElement re) {
        return "<FIELD attrname=\"" + re.getName() + "\" " + this.getDelphiFieldType(re.getType(), re.getSize()) + "/>";
    }

    boolean treatEmptyStringsAsNull(RowContainer rc, RowElement re) {
        if (rc.getScrubber() == null) {
            return true;
        }
        return rc.getScrubber().treatEmptyStringsAsNull(rc.getName(), re.getName());
    }

    public void output(SQLRowContainer rc, OutputStream f) throws IOException, SQLException, PrimaveraDatabaseException {
        RowElement ire;
        f.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><DATAPACKET Version=\"2.0\"><METADATA><FIELDS>".getBytes("UTF-8"));
        Iterator<RowElement> rowIter = rc.iterator();
        while (rowIter.hasNext()) {
            ire = rowIter.next();
            f.write(this.fieldText(ire).getBytes("UTF-8"));
        }
        f.write("</FIELDS><PARAMS/></METADATA><ROWDATA>".getBytes("UTF-8"));
        while (rc.Next()) {
            f.write("<ROW".getBytes("UTF-8"));
            rowIter = rc.iterator();
            while (rowIter.hasNext()) {
                String s;
                boolean treatEmptyStringAsNull;
                ire = rowIter.next();
                if (ire.isNull(treatEmptyStringAsNull = this.treatEmptyStringsAsNull(rc, ire))) continue;
                if (!XMLRowGenerator.isLobType(ire.getType())) {
                    try {
                        s = " " + ire.getName() + "=\"" + ire.getXMLSafeValue() + "\"";
                        f.write(s.getBytes("UTF-8"));
                        continue;
                    }
                    catch (Exception ex) {
                        throw new PrimaveraDatabaseException(ex.getMessage());
                    }
                }
                try {
                    s = " " + ire.getName() + "=\"" + "b64" + Base64.encodeBytes(ire.getValue().getBytes("UTF-8")) + "\"";
                    f.write(s.getBytes("UTF-8"));
                }
                catch (Exception ex) {
                    throw new PrimaveraDatabaseException(ex.getMessage());
                }
            }
            f.write("/>".getBytes("UTF-8"));
        }
        f.write("</ROWDATA></DATAPACKET>".getBytes("UTF-8"));
    }
}

