/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader.input;

import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.Dataloader.InputStreamZipFileInputStreamProvider;
import com.primavera.database.tools.Dataloader.URLZipInputStreamProvider;
import com.primavera.database.tools.Dataloader.ZipInputStreamProvider;
import com.primavera.database.tools.Dataloader.input.ZipInputEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipInputter {
    private ZipInputStreamProvider m_inputProvider;
    private final ArrayList<String> tableList = new ArrayList();

    public ZipInputter() {
    }

    public ZipInputter(String filename) throws DatabaseToolException {
        this.m_inputProvider = new URLZipInputStreamProvider(filename);
    }

    public ZipInputter(URL newUrl) {
        this.m_inputProvider = new URLZipInputStreamProvider(newUrl);
    }

    public ZipInputter(InputStream input) {
        this.m_inputProvider = new InputStreamZipFileInputStreamProvider(input);
    }

    public void open() throws DatabaseToolException {
        if (this.m_inputProvider == null) {
            throw new DatabaseToolException("No input provider specified");
        }
        try {
            ZipEntry entry;
            ZipInputStream zipin = this.m_inputProvider.getInputStream();
            this.tableList.clear();
            while ((entry = zipin.getNextEntry()) != null) {
                if (entry.getName().substring(entry.getName().indexOf("."), entry.getName().length()).compareToIgnoreCase(".XML") != 0) continue;
                this.tableList.add(entry.getName().substring(0, entry.getName().length() - 4).toUpperCase());
            }
        }
        catch (IOException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
    }

    public ZipInputEntry getEntry(String name) throws DatabaseToolException {
        if (this.m_inputProvider == null) {
            throw new DatabaseToolException("No zip input available");
        }
        try {
            ZipEntry entry;
            ZipInputStream zipin = this.m_inputProvider.getInputStream();
            while ((entry = zipin.getNextEntry()) != null && name.compareToIgnoreCase(entry.getName()) != 0) {
                entry = null;
            }
            if (entry != null) {
                ZipInputEntry zie = new ZipInputEntry();
                zie.setZipEntry(entry);
                zie.setReader(new BufferedReader(new InputStreamReader((InputStream)zipin, "UTF-8")));
                return zie;
            }
            return null;
        }
        catch (IOException e) {
            throw new DatabaseToolException(e.getMessage());
        }
    }

    public ArrayList<String> getTableList() {
        return this.tableList;
    }

    protected final void setInputProvider(ZipInputStreamProvider inputProvider) {
        this.m_inputProvider = inputProvider;
    }
}

