/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.Dataloader.ZipInputStreamProvider;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipInputStream;

public class URLZipInputStreamProvider
implements ZipInputStreamProvider {
    private URL m_url;

    public URLZipInputStreamProvider() {
    }

    public URLZipInputStreamProvider(URL newUrl) {
        this.m_url = newUrl;
    }

    public URLZipInputStreamProvider(String url) throws DatabaseToolException {
        try {
            this.m_url = new File(url).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new DatabaseToolException("Unable to to create zip stream from url malformed url " + url, e);
        }
    }

    @Override
    public ZipInputStream getInputStream() throws DatabaseToolException {
        try {
            if (this.m_url == null) {
                throw new DatabaseToolException("No zip file available");
            }
            return new ZipInputStream(this.m_url.openStream());
        }
        catch (IOException e) {
            throw new DatabaseToolException("Unable to open zip file for URL " + this.m_url, e);
        }
    }

    public final URL getUrl() {
        return this.m_url;
    }

    public final void setUrl(URL url) {
        this.m_url = url;
    }

    public final void setUrl(String url) throws DatabaseToolException {
        try {
            this.m_url = new File(url).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new DatabaseToolException("Unable to to create zip stream from url malformed url " + this.m_url, e);
        }
    }

    @Override
    public String location() {
        return this.m_url.toString();
    }
}

