/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.common.container.RowContainer;
import com.primavera.database.common.container.RowElement;
import com.primavera.database.common.container.RowScrubber;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class TableScrubber
implements RowScrubber {
    private ArrayList<String> m_scrub_list = new ArrayList();
    private ArrayList<String> m_scrub_table_list = new ArrayList();
    private ArrayList<String> m_excluded = new ArrayList();
    private ArrayList<String> m_force_base64 = new ArrayList();
    private Set<String> m_allowEmptyString = new HashSet<String>();

    public void add(String table, String element) {
        this.m_scrub_list.add(table.toUpperCase() + ":" + element.toUpperCase());
        this.m_scrub_table_list.add(table.toUpperCase());
    }

    public void addExcluded(String table) {
        if (!this.m_excluded.contains(table.toUpperCase())) {
            this.m_excluded.add(table.toUpperCase());
        }
    }

    public void addForceBase64(String table, String element) {
        this.m_force_base64.add(table.toUpperCase() + ":" + element.toUpperCase());
    }

    public void addAllowEmptyString(String table, String element) {
        this.m_allowEmptyString.add(table.toUpperCase() + ":" + element.toUpperCase());
    }

    @Override
    public RowElement clean(RowElement elem) {
        return elem;
    }

    @Override
    public boolean keepRow(RowContainer rc) {
        return true;
    }

    @Override
    public boolean needsElementScrub(String name, String elemname) {
        return this.m_scrub_list.contains(name.toUpperCase() + ":" + elemname.toUpperCase());
    }

    @Override
    public boolean needsScrub(String name) {
        return this.m_scrub_table_list.contains(name.toUpperCase());
    }

    @Override
    public boolean isExcluded(String name) {
        return this.m_excluded.contains(name.toUpperCase());
    }

    @Override
    public boolean forceBase64(String name, String elemname) {
        return this.m_force_base64.contains(name.toUpperCase() + ":" + elemname.toUpperCase());
    }

    @Override
    public boolean treatEmptyStringsAsNull(String name, String elemname) {
        return !this.m_allowEmptyString.contains(name.toUpperCase() + ":" + elemname.toUpperCase());
    }
}

