/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.Dataloader.ZipOutputStreamProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.zip.ZipOutputStream;

public class FileZipOutputProvider
implements ZipOutputStreamProvider {
    private static final String DEFAULT_ZIP_FILE_NAME = "prmdatabase.zip";
    private String m_zipPath = System.getProperty("java.io.tmpdir");
    private String m_zipName = "prmdatabase.zip";

    public FileZipOutputProvider() {
    }

    public FileZipOutputProvider(String path) {
        File file = new File(path);
        this.m_zipName = file.getName();
        this.m_zipPath = file.getParent();
    }

    @Override
    public ZipOutputStream getOutputStream() throws DatabaseToolException {
        try {
            return new ZipOutputStream(new FileOutputStream(this.m_zipPath + this.m_zipName));
        }
        catch (FileNotFoundException e) {
            throw new DatabaseToolException("Unable to open the file " + this.m_zipName + " in " + this.m_zipPath + " for writing output", e);
        }
    }

    protected final String getZipName() {
        return this.m_zipName;
    }

    protected final void setZipName(String zipName) {
        this.m_zipName = zipName;
    }

    protected final String getZipPath() {
        return this.m_zipPath;
    }

    protected final void setZipPath(String zipPath) {
        this.m_zipPath = zipPath;
    }
}

