/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.PhoenixException;
import com.primavera.common.util.EntryPoint;
import com.primavera.database.PrimaveraDatabaseException;
import com.primavera.database.common.DataDictionary;
import com.primavera.database.common.DatabaseHelper;
import com.primavera.database.common.ProductVersion;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.TableManipulatorInterface;
import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DSType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.container.RowScrubber;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.Dataloader.DatabaseDataloaderInputDS;
import com.primavera.database.tools.Dataloader.DatabaseDataloaderOutputDS;
import com.primavera.database.tools.Dataloader.DataloaderEvent;
import com.primavera.database.tools.Dataloader.DataloaderInputDS;
import com.primavera.database.tools.Dataloader.DataloaderListener;
import com.primavera.database.tools.Dataloader.DataloaderOutputDS;
import com.primavera.database.tools.Dataloader.DependentOrder;
import com.primavera.database.tools.Dataloader.FileZipOutputProvider;
import com.primavera.database.tools.Dataloader.ZipDataloaderInputDS;
import com.primavera.database.tools.Dataloader.ZipDataloaderOutputDS;
import com.primavera.database.tools.Dataloader.input.ZipInputter;
import com.primavera.database.tools.Dataloader.output.ZipOutputter;
import com.primavera.database.tools.common.DynamicSchemaBundleManager;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Dataloader {
    private static final int DEFAULT_COMMIT_POINT = 5000;
    private DataloaderInputDS m_sourceDS = null;
    private DataloaderOutputDS m_targetDS = null;
    private List<String> m_loadList;
    private ZipInputter m_zipin;
    private boolean m_clearTables = true;
    private RowScrubber m_scrubber = null;
    private int m_tablesProcessed = 0;
    private int m_rowsProcessed = 0;
    private long dataloadStart;
    private long dataloadEnd;
    private long tableloadStart;
    private long tableloadEnd;
    private String m_currentTable;
    private int m_commitPoint = 5000;
    private boolean m_commitOnProgress = true;
    ArrayList<DataloaderListener> m_listeners = new ArrayList();
    ArrayList<String> m_tables = new ArrayList();

    public void addTable(String table) {
        this.m_tables.add(table);
    }

    public void addListener(DataloaderListener listener) {
        this.m_listeners.add(listener);
    }

    public RowScrubber getScrubber() {
        return this.m_scrubber;
    }

    public void setScrubber(RowScrubber scrubber) {
        this.m_scrubber = scrubber;
    }

    public boolean isClearTables() {
        return this.m_clearTables;
    }

    public void setClearTables(boolean clearTables) {
        this.m_clearTables = clearTables;
    }

    private URL sampleDataUrl(String samplestring) {
        String productString = ConnectStringParse.extractProductVersion(samplestring);
        String version = DynamicSchemaBundleManager.getDefaultVersion(productString);
        return this.sampleDataUrl(samplestring, version);
    }

    private URL sampleDataUrl(String samplestring, String version) {
        String productString = ConnectStringParse.extractProductVersion(samplestring);
        String strUrl = "/sampledata/" + productString + "_" + version + "/" + samplestring;
        return this.getClass().getResource(strUrl);
    }

    private URL sampleDataUrl(String samplestring, ProductVersion version) {
        return this.sampleDataUrl(samplestring, version.toString());
    }

    public void setSourceConnectString(String connectstring) throws DatabaseToolException {
        this.setSourceConnectString(connectstring, null);
    }

    public void setSourceConnectString(String connectstring, ProductVersion version) throws DatabaseToolException {
        ConnectStringParse parsedConnectionString = new ConnectStringParse(connectstring);
        if (parsedConnectionString.getConnectionType() == DSType.FILE) {
            this.setSourceDS(new ZipDataloaderInputDS(parsedConnectionString.getFilename(), DSType.FILE));
        } else if (parsedConnectionString.getConnectionType() == DSType.SAMPLE) {
            if (version != null) {
                this.setSourceDS(new ZipDataloaderInputDS(this.sampleDataUrl(parsedConnectionString.getSampleString(), version), DSType.SAMPLE));
            } else {
                this.setSourceDS(new ZipDataloaderInputDS(this.sampleDataUrl(parsedConnectionString.getSampleString()), DSType.SAMPLE));
            }
        } else {
            try {
                this.setSourceDS(new DatabaseDataloaderInputDS(new DatabaseConnection(connectstring)));
            }
            catch (SQLException e) {
                throw new DatabaseToolException(e.getMessage(), e.getErrorCode(), e.getSQLState(), e);
            }
        }
        DBMTLogger.info("Dataloader source set to " + parsedConnectionString.getConnectstringForDisplay());
    }

    public void setTargetConnectString(String connectstring) throws DatabaseToolException {
        ConnectStringParse parsedConnectionString = new ConnectStringParse(connectstring);
        if (parsedConnectionString.getConnectionType() == DSType.FILE) {
            this.setTargetDS(new ZipDataloaderOutputDS());
        } else {
            try {
                this.setTargetDS(new DatabaseDataloaderOutputDS(new DatabaseConnection(connectstring)));
            }
            catch (SQLException e) {
                throw new DatabaseToolException(e.getMessage(), e.getErrorCode(), e.getSQLState(), e);
            }
        }
        DBMTLogger.info("Dataloader target set to " + parsedConnectionString.getConnectstringForDisplay());
    }

    public void setSourceDS(DataloaderInputDS dataSource) {
        this.m_sourceDS = dataSource;
    }

    public DataloaderInputDS getSourceDS() {
        return this.m_sourceDS;
    }

    public void setTargetDS(DataloaderOutputDS dataSource) {
        this.m_targetDS = dataSource;
    }

    public DataloaderOutputDS getTargetDS() {
        return this.m_targetDS;
    }

    public void setSourceDS(InputStream input) throws DatabaseToolException {
        this.m_zipin = new ZipInputter(input);
        this.m_zipin.open();
    }

    public String getSelectSQL(String tablename, Connection conn) throws DatabaseToolException {
        String sql = null;
        try {
            DataDictionary dd = new DataDictionary(conn);
            ArrayList<String> columns = dd.getColumns(tablename);
            Iterator i = columns.iterator();
            while (i.hasNext()) {
            }
        }
        catch (SQLException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
        return sql;
    }

    public void run() throws DatabaseToolException {
        this.sendDataLoadBegin();
        this.m_tablesProcessed = -1;
        if (this.m_sourceDS.getDSType() == DSType.FILE) {
            ((ZipDataloaderInputDS)this.m_sourceDS).getXmlRowGen().setTableManipulator(((ZipDataloaderInputDS)this.m_sourceDS).getTableManipulator());
            ZipDataloaderInputDS zdids = (ZipDataloaderInputDS)this.m_sourceDS;
            zdids.getXmlRowGen().getTableManipulator();
        }
        if (this.m_sourceDS.getDSType() == DSType.FILE && this.m_targetDS.getDSType() == DSType.FILE) {
            throw new DatabaseToolException("File to File pump not supported");
        }
        if (this.m_sourceDS.getDSType() == DSType.DATABASE && this.m_targetDS.getDSType() == DSType.FILE) {
            FileZipOutputProvider outputProvider = new FileZipOutputProvider();
            ZipOutputter zipOutputter = new ZipOutputter(outputProvider);
            zipOutputter.setTables(this.m_tables);
            zipOutputter.setTablePattern("%");
            try {
                zipOutputter.output(((DatabaseDataloaderInputDS)this.m_sourceDS).getDbConnection().getConnection());
            }
            catch (PrimaveraDatabaseException e) {
                Log.error(e.getMessage());
            }
            return;
        }
        this.m_loadList = this.m_tables.isEmpty() ? this.getLoadList() : this.m_tables;
        if (this.m_sourceDS.getDSType() == DSType.DATABASE && this.m_targetDS.getDSType() == DSType.DATABASE) {
            block19: {
                try {
                    if (this.m_clearTables) {
                        this.m_targetDS.clearTargetTables(this.m_loadList);
                    }
                    DatabaseConnection sourceConnection = ((DatabaseDataloaderInputDS)this.m_sourceDS).getDbConnection();
                    DatabaseConnection targetConnection = ((DatabaseDataloaderOutputDS)this.m_targetDS).getDbConnection();
                    try {
                        DatabaseHelper.disableTblTrigger(targetConnection.getConnection(), targetConnection.getServerType());
                        for (String this.m_currentTable : this.m_loadList) {
                            DBMTLogger.info(Channel.DEV, "Current Table: " + this.m_currentTable);
                            this.m_sourceDS.init(this.m_targetDS.getInserter(), this);
                            this.m_targetDS.beforeTableStarted(this.m_currentTable);
                            this.sendTableLoadBegin();
                            ((DatabaseDataloaderInputDS)this.m_sourceDS).getDbRowGen().run(sourceConnection.getConnection(), targetConnection.getConnection(), this.m_currentTable);
                            ++this.m_tablesProcessed;
                            this.sendTableLoadComplete(this.m_currentTable);
                            this.m_rowsProcessed = 0;
                        }
                        DatabaseHelper.enableTblTrigger(targetConnection.getConnection(), targetConnection.getServerType());
                    }
                    catch (Exception e) {
                        throw new DatabaseToolException(e.getMessage());
                    }
                    if (targetConnection.getServerType() == ServerType.ORACLE) {
                        try {
                            DBMTLogger.info("Enabling all disabled Foreign keys ");
                            DatabaseHelper.enableForeignkeys(targetConnection.getConnection());
                        }
                        catch (SQLException e) {
                            throw new DatabaseToolException(e.getMessage());
                        }
                    }
                    this.sendDataLoadComplete();
                }
                catch (PrimaveraDatabaseException e) {
                    Log.error(e.getMessage(), e);
                    if (!e.getMessage().contains("ORA-01000")) break block19;
                    throw new RuntimeException(e.getLocalizedMessage());
                }
            }
            return;
        }
        if (this.m_clearTables) {
            this.m_targetDS.clearTargetTables(this.m_loadList);
        }
        this.loadTargetTables(this.m_loadList);
        DatabaseConnection targetConnection = ((DatabaseDataloaderOutputDS)this.m_targetDS).getDbConnection();
        if (targetConnection.getServerType() == ServerType.ORACLE) {
            try {
                DBMTLogger.info("Enabling all disabled Foreign keys ");
                DatabaseHelper.enableForeignkeys(targetConnection.getConnection());
            }
            catch (SQLException e) {
                throw new DatabaseToolException(e.getMessage());
            }
        }
        this.sendDataLoadComplete();
    }

    public void overwritePasswords(String password) throws DatabaseToolException {
        DatabaseConnection targetConnection = ((DatabaseDataloaderOutputDS)this.m_targetDS).getDbConnection();
        try {
            PreparedStatement stmt = targetConnection.getConnection().prepareStatement("update users set passwd = ?");
            stmt.setString(1, EntryPoint.e((String)password));
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseToolException(e.getMessage());
        }
        catch (PhoenixException e) {
            throw new DatabaseToolException(e.getMessage());
        }
    }

    public int getTablesCount() {
        return this.m_loadList.size();
    }

    private void loadTargetTables(List<String> list) throws DatabaseToolException {
        DatabaseConnection targetConnection = ((DatabaseDataloaderOutputDS)this.m_targetDS).getDbConnection();
        try {
            DBMTLogger.info("Disabling Required Trigger");
            DatabaseHelper.disableTblTrigger(targetConnection.getConnection(), targetConnection.getServerType());
        }
        catch (Exception e) {
            throw new DatabaseToolException(e.getMessage());
        }
        for (String this.m_currentTable : list) {
            this.sendTableLoadBegin();
            this.m_sourceDS.init(this.m_currentTable, this.m_targetDS.getInserter(), this);
            this.m_targetDS.beforeTableStarted(this.m_currentTable);
            if (this.m_sourceDS.getDSType() == DSType.FILE || this.m_sourceDS.getDSType() == DSType.SAMPLE) {
                try {
                    ((ZipDataloaderInputDS)this.m_sourceDS).getXmlRowGen().setTableManipulator(((ZipDataloaderInputDS)this.m_sourceDS).getTableManipulator());
                    ZipDataloaderInputDS zdids = (ZipDataloaderInputDS)this.m_sourceDS;
                    TableManipulatorInterface tm = zdids.getXmlRowGen().getTableManipulator();
                    if (!tm.isExcluded(this.m_currentTable)) {
                        ((ZipDataloaderInputDS)this.m_sourceDS).getXmlRowGen().run(this.m_currentTable);
                    }
                }
                catch (Exception e) {
                    throw new DatabaseToolException(e.getMessage());
                }
            }
            ++this.m_tablesProcessed;
            this.m_targetDS.afterTableFinished(this.m_currentTable);
        }
        try {
            DBMTLogger.info("Enabling Required Trigger");
            DatabaseHelper.enableTblTrigger(targetConnection.getConnection(), targetConnection.getServerType());
        }
        catch (Exception e) {
            throw new DatabaseToolException(e.getMessage());
        }
    }

    private List<String> getLoadList() throws DatabaseToolException {
        List<String> list = null;
        List<String> sourceTables = this.m_sourceDS.getTableList();
        List<String> targetTables = this.m_targetDS.getTableList();
        if (sourceTables.size() == 0) {
            throw new DatabaseToolException("Source table list is empty");
        }
        if (targetTables.size() == 0) {
            throw new DatabaseToolException("Target table list is empty");
        }
        if (this.m_sourceDS.getDSType() == DSType.DATABASE && this.m_targetDS.getDSType() == DSType.FILE) {
            return sourceTables;
        }
        int i = 0;
        while (i < sourceTables.size()) {
            String srcTable = sourceTables.get(i);
            if (!targetTables.contains(srcTable)) {
                sourceTables.remove(srcTable);
                continue;
            }
            ++i;
        }
        if (sourceTables.size() > 0) {
            i = 0;
            while (i < targetTables.size()) {
                String targetTable = targetTables.get(i);
                if (!sourceTables.contains(targetTable)) {
                    targetTables.remove(targetTable);
                    continue;
                }
                ++i;
            }
            list = targetTables;
        }
        if (this.m_targetDS.getDSType() == DSType.DATABASE) {
            list = this.dependentOrder(list);
        }
        return list;
    }

    private List<String> dependentOrder(List<String> tablist) throws DatabaseToolException {
        DependentOrder dep = new DependentOrder(((DatabaseDataloaderOutputDS)this.m_targetDS).getDbConnection(), tablist);
        return dep.getOrderList();
    }

    public int pctComplete() {
        return this.m_tablesProcessed / this.getTablesCount() * 100;
    }

    public void sendDataLoadBegin() {
        this.dataloadStart = System.currentTimeMillis();
        DataloaderEvent event = new DataloaderEvent();
        this.m_tablesProcessed = 0;
        event.setTablesProcessed(0);
        for (DataloaderListener listener : this.m_listeners) {
            listener.dataLoadBegin(event);
        }
    }

    public void sendDataLoadComplete() {
        this.dataloadEnd = System.currentTimeMillis();
        long dataloadElapsed = this.dataloadEnd - this.dataloadStart;
        DataloaderEvent event = new DataloaderEvent();
        event.setTotalTables(this.getTablesCount());
        event.setTablesProcessed(this.m_tablesProcessed);
        event.setElapsedSeconds((double)dataloadElapsed * 0.001);
        for (DataloaderListener listener : this.m_listeners) {
            listener.dataLoadComplete(event);
        }
    }

    public void sendTableLoadBegin() {
        DataloaderEvent event = new DataloaderEvent();
        this.tableloadStart = System.currentTimeMillis();
        this.m_rowsProcessed = 0;
        event.setTotalTables(this.getTablesCount());
        event.setTablesProcessed(this.m_tablesProcessed);
        event.setTableName(this.m_currentTable);
        this.m_targetDS.addSqlDataloaderEvent(event);
        for (DataloaderListener listener : this.m_listeners) {
            listener.tableLoadBegin(event);
        }
    }

    public void sendTableLoadComplete(String tablename) throws DatabaseToolException {
        DataloaderEvent event = new DataloaderEvent();
        this.tableloadEnd = System.currentTimeMillis();
        long tableloadElapsed = this.tableloadEnd - this.tableloadStart;
        event.setTotalTables(this.getTablesCount());
        event.setTablesProcessed(this.m_tablesProcessed);
        event.setTableName(this.m_currentTable);
        event.setRowsProcessed(this.m_rowsProcessed);
        event.setElapsedSeconds((double)tableloadElapsed * 0.001);
        this.m_targetDS.addSqlDataloaderEvent(event);
        for (DataloaderListener listener : this.m_listeners) {
            listener.tableLoadComplete(event);
        }
        this.m_targetDS.afterTableFinished(tablename);
    }

    public void sendRowBegin() {
        DataloaderEvent event = new DataloaderEvent();
        event.setTotalTables(this.getTablesCount());
        event.setTablesProcessed(this.m_tablesProcessed);
        event.setRowsProcessed(this.m_rowsProcessed);
        this.m_targetDS.addSqlDataloaderEvent(event);
        for (DataloaderListener listener : this.m_listeners) {
            listener.rowBegin(event);
        }
    }

    public void sendRowComplete() {
        DataloaderEvent event = new DataloaderEvent();
        ++this.m_rowsProcessed;
        event.setTotalTables(this.getTablesCount());
        event.setTablesProcessed(this.m_tablesProcessed);
        event.setRowsProcessed(this.m_rowsProcessed);
        this.m_targetDS.addSqlDataloaderEvent(event);
        for (DataloaderListener listener : this.m_listeners) {
            listener.rowComplete(event);
        }
    }

    public void sendDataLoadError(Throwable e) {
        DataloaderEvent event = new DataloaderEvent();
        this.m_targetDS.addSqlDataloaderEvent(event);
        event.setException((Exception)e);
        for (DataloaderListener listener : this.m_listeners) {
            listener.dataLoadError(event);
        }
    }

    public void sendTableProgress() {
        DataloaderEvent event = new DataloaderEvent();
        event.setTotalTables(this.getTablesCount());
        event.setTablesProcessed(this.m_tablesProcessed);
        event.setRowsProcessed(this.m_rowsProcessed);
        event.setTableName(this.m_currentTable);
        this.m_targetDS.addSqlDataloaderEvent(event);
        for (DataloaderListener listener : this.m_listeners) {
            listener.tableProgress(event);
        }
    }

    public String getCurrentTable() {
        return this.m_currentTable;
    }

    public void setCurrentTable(String currentTable) {
        this.m_currentTable = currentTable;
    }

    public int getCommitPoint() {
        return this.m_commitPoint;
    }

    public void setCommitPoint(int point) {
        this.m_commitPoint = point;
    }

    public void targetCommit() throws SQLException {
        Connection connection;
        if (this.isCommitOnProgress() && !(connection = ((DatabaseDataloaderOutputDS)this.m_targetDS).getDbConnection().getConnection()).getAutoCommit()) {
            connection.commit();
        }
    }

    public boolean isCommitOnProgress() {
        return this.m_commitOnProgress;
    }

    public void setCommitOnProgress(boolean onProgress) {
        this.m_commitOnProgress = onProgress;
    }
}

