/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.common.DataDictionary;
import com.primavera.database.common.DatabaseHelper;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DSType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.container.SQLRowInserter;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.Dataloader.DataloaderEvent;
import com.primavera.database.tools.Dataloader.DataloaderOutputDS;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DatabaseDataloaderOutputDS
implements DataloaderOutputDS {
    private DatabaseConnection m_dbConnection;
    private SQLRowInserter m_inserter = new SQLRowInserter();

    public DatabaseDataloaderOutputDS(DatabaseConnection dbConnection) throws DatabaseToolException {
        if (dbConnection == null) {
            throw new DatabaseToolException("DatabaseConnection cannot be null in DatabaseDataloaderOutputDS constructor");
        }
        this.m_dbConnection = dbConnection;
    }

    @Override
    public DSType getDSType() {
        return DSType.DATABASE;
    }

    @Override
    public List<String> getTableList() throws DatabaseToolException {
        return this.getTables(this.m_dbConnection.getConnection());
    }

    @Override
    public void beforeTableStarted(String tableName) throws DatabaseToolException {
        try {
            if (this.m_dbConnection.getServerType() == ServerType.SQLSERVER) {
                DatabaseHelper.setSqlServerIdentityInsert(this.m_dbConnection, tableName, true);
            }
        }
        catch (SQLException e) {
            throw new DatabaseToolException(e.getLocalizedMessage());
        }
        this.m_inserter.setConnection(this.m_dbConnection.getConnection());
    }

    @Override
    public void clearTargetTables(List<String> tables) throws DatabaseToolException {
        for (int i = tables.size() - 1; i >= 0; --i) {
            String tablename = tables.get(i);
            try {
                Log.info("Clearing table " + tablename);
                DatabaseHelper.truncateTable(this.m_dbConnection.getConnection(), tablename, this.m_dbConnection.getServerType());
                continue;
            }
            catch (SQLException e) {
                throw new DatabaseToolException(e.getMessage());
            }
        }
    }

    private ArrayList<String> getTables(Connection conn) throws DatabaseToolException {
        ArrayList<String> list = null;
        try {
            DataDictionary dd = new DataDictionary(conn);
            list = dd.getTables(null);
        }
        catch (SQLException e) {
            throw new DatabaseToolException(e.getMessage());
        }
        return list;
    }

    @Override
    public final SQLRowInserter getInserter() {
        return this.m_inserter;
    }

    @Override
    public void addSqlDataloaderEvent(DataloaderEvent event) {
        event.setInsertStatement(this.m_inserter.getSql());
    }

    @Override
    public void afterTableFinished(String tablename) {
        try {
            if (this.m_dbConnection.getServerType() == ServerType.SQLSERVER) {
                DatabaseHelper.setSqlServerIdentityInsert(this.m_dbConnection, tablename, false);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected final DatabaseConnection getDbConnection() {
        return this.m_dbConnection;
    }
}

