/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.DatabaseToXML;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.tools.DatabaseToXML.DatabaseToXML;
import java.sql.Connection;
import java.sql.DriverManager;

public class RunDatabaseToXML {
    private static Connection m_connection;
    private static ConnectStringParse m_parsedConnectionString;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java -classpath {jar file} " + RunDatabaseToXML.class.getName() + " {connection string} {output xml file}");
            System.exit(-1);
        }
        try {
            DatabaseToXML generator = new DatabaseToXML();
            generator.setOutputToConsole(true);
            System.out.println("Connection String: " + args[0]);
            System.out.println("Username: " + m_parsedConnectionString.getUsername());
            System.out.println("Password: " + m_parsedConnectionString.getPassword());
            System.out.println("Server: " + m_parsedConnectionString.getServer());
            System.out.println("Database: " + m_parsedConnectionString.getDatabase());
            RunDatabaseToXML.Connect(args[0]);
            generator.setConnection(m_connection);
            generator.setOutputFile(args[1]);
            generator.generate();
            m_connection.close();
            System.out.append("Complete.");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void Connect(String connectstring) throws Exception {
        m_parsedConnectionString = new ConnectStringParse(connectstring);
        String username = m_parsedConnectionString.getUsername();
        String password = m_parsedConnectionString.getPassword();
        String server = m_parsedConnectionString.getServer();
        String database = m_parsedConnectionString.getDatabase();
        ServerType dbtype = m_parsedConnectionString.getDbtype();
        System.out.println("Username: " + username);
        System.out.println("Password: " + password);
        System.out.println("Server: " + server);
        System.out.println("Database: " + database);
        String url = m_parsedConnectionString.getDatabaseUrl();
        System.out.println("Url: " + url);
        if (dbtype == ServerType.ORACLE) {
            Class.forName("oracle.jdbc.OracleDriver");
        } else if (dbtype == ServerType.SQLSERVER) {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        } else {
            throw new Exception("Database type " + (Object)((Object)dbtype) + " not supported");
        }
        m_connection = DriverManager.getConnection(url, username, password);
        System.out.println("Connect to " + url);
    }
}

