/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.DatabaseToXML;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DatabaseToXML {
    private final Document xmldoc;
    private final Element root;
    private Connection connection;
    private String outputFile;
    private boolean outputToConsole = false;

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public DatabaseToXML() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.xmldoc = db.newDocument();
        this.root = this.xmldoc.createElement("PrimaveraDatabaseSchema");
    }

    private List<TableInfo> getTableList() throws Exception {
        ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
        try {
            Statement stmt = this.connection.createStatement();
            ResultSet rs = stmt.executeQuery("select NAME ,TABLETYPE, TABLESPACE from pdtk_table order by NAME");
            while (rs.next()) {
                TableInfo tableinfo = new TableInfo();
                tableinfo.name = rs.getString("NAME");
                tableinfo.tabletype = rs.getString("TABLETYPE");
                tableinfo.tablespace = rs.getString("TABLESPACE");
                tableList.add(tableinfo);
            }
        }
        catch (SQLException e) {
            throw new Exception(e.getMessage());
        }
        return tableList;
    }

    private void addChildElements(Element parent, String type, String table_name) throws Exception {
        String sql = "select * from pdtk_" + type.toLowerCase();
        if (table_name.trim().length() > 0) {
            sql = sql.concat(" where \"TABLE\" = '" + table_name + "'");
        }
        if ("FIELD".equalsIgnoreCase(type)) {
            sql = sql.concat(" order by position");
        }
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        ResultSetMetaData md = rs.getMetaData();
        while (rs.next()) {
            Element e = this.xmldoc.createElement(type.toUpperCase());
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                e.setAttribute(md.getColumnName(i), rs.getString(i));
            }
            parent.appendChild(e);
        }
        stmt.close();
    }

    public void generate() throws Exception {
        if (this.connection == null || this.connection.isClosed()) {
            throw new Exception("Connection is closed or null");
        }
        List<TableInfo> tableSet = this.getTableList();
        Element e = null;
        for (TableInfo tableInfo : tableSet) {
            System.out.println(tableInfo.name);
            e = this.xmldoc.createElement("TABLE");
            e.setAttribute("NAME", tableInfo.name);
            e.setAttribute("TABLETYPE", tableInfo.tabletype);
            e.setAttribute("TABLESPACE", tableInfo.tablespace);
            this.addChildElements(e, "FIELD", tableInfo.name);
            this.addChildElements(e, "TRIGGER", tableInfo.name);
            this.addChildElements(e, "INDEX", tableInfo.name);
            this.addChildElements(e, "CONSTRAINT", tableInfo.name);
            this.root.appendChild(e);
        }
        this.addChildElements(this.root, "VIEW", "");
        this.addChildElements(this.root, "PROCEDURE", "");
        this.addChildElements(this.root, "SEQUENCE", "");
        this.xmldoc.appendChild(this.root);
        OutputFormat of = new OutputFormat("XML", "ISO-8859-1", true);
        of.setIndent(1);
        of.setIndenting(true);
        if (this.outputToConsole) {
            XMLSerializer serializer = new XMLSerializer((OutputStream)System.out, of);
            serializer.asDOMSerializer();
            serializer.serialize(this.xmldoc.getDocumentElement());
        }
        if (this.outputFile.length() > 0) {
            FileOutputStream fos = new FileOutputStream(this.outputFile);
            XMLSerializer serializer = new XMLSerializer((OutputStream)fos, of);
            serializer.asDOMSerializer();
            serializer.serialize(this.xmldoc.getDocumentElement());
            fos.close();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    private static class TableInfo {
        String name;
        String tabletype;
        String tablespace;

        private TableInfo() {
        }
    }
}

