/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.DAFImporter;

import com.primavera.database.common.TableManipulator;
import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.DAFImporter.CommonMethods;
import com.primavera.database.tools.DAFImporter.CreateOROperations;
import com.primavera.database.tools.DAFImporter.CreateSSOperations;
import com.primavera.database.tools.DAFImporter.DBOperationsInterface;
import com.primavera.database.tools.DAFImporter.RunDataloader;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.Dataloader.Dataloader;
import com.primavera.database.tools.Dataloader.ZipDataloaderInputDS;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DAFImporter {
    public static final String LOG_FILE_NAME = "DAFImporter.log";
    private static String m_pmVersion = null;
    private static String s_dafDatabaseVersion = null;
    private static boolean s_verbose = false;
    private static String dbType = null;
    private static ConnectStringParse primaryConnection = null;
    private static ConnectStringParse connectFile = null;
    private static String sysUsername = null;
    private static String sysPassword = null;
    private static String s_privuser = null;
    private static String s_pubuser = null;
    private static String s_bgjobuser = null;
    private static String s_pxrptuser = null;
    private static String s_pxrptuser_password = null;

    public static void main(String[] args) throws DatabaseToolException, SQLException {
        Log.setLogFileName(LOG_FILE_NAME);
        DAFImporter.setUp(args);
        DBOperationsInterface dbOperator = null;
        Log.info("Using DAF File: " + connectFile.getFilename());
        dbOperator = DAFImporter.getDBOperations(dbType);
        dbOperator.setUp(primaryConnection.getConnectstring(), "file:" + connectFile.getFilename(), sysUsername, sysPassword, m_pmVersion);
        Properties extendedProperties = new Properties();
        if ("oracle".equalsIgnoreCase(dbType)) {
            extendedProperties = new Properties();
            String sqlOracleFileNames = "SELECT f.file_name FROM sys.dba_data_files  f, sys.dba_tablespaces t WHERE t.tablespace_name = f.tablespace_name AND t.contents = 'PERMANENT' and f.tablespace_name like ";
            extendedProperties.setProperty("pm.or.data_path", CommonMethods.getPath(sqlOracleFileNames + "'%DAT%'", dbOperator.getSystemConnection()));
            extendedProperties.setProperty("pm.or.data_size", "256M");
            extendedProperties.setProperty("pm.or.index_path", CommonMethods.getPath(sqlOracleFileNames + "'%NDX%'", dbOperator.getSystemConnection()));
            extendedProperties.setProperty("pm.or.index_size", "256M");
            extendedProperties.setProperty("pm.or.lob_path", CommonMethods.getPath(sqlOracleFileNames + "'%LOB%'", dbOperator.getSystemConnection()));
            extendedProperties.setProperty("pm.or.lob_size", "256M");
            extendedProperties.setProperty("pm.or.administrative_user", dbOperator.getAdminConnection().getUsername());
            extendedProperties.setProperty("pm.or.administrative_password", dbOperator.getAdminConnection().getPassword());
            extendedProperties.setProperty("pm.or.privileged_user", s_privuser);
            extendedProperties.setProperty("pm.or.privileged_password", s_privuser);
            extendedProperties.setProperty("pm.or.public_user", s_pubuser);
            extendedProperties.setProperty("pm.or.public_password", s_pubuser);
            extendedProperties.setProperty("pm.or.bgjob_user", s_bgjobuser);
            extendedProperties.setProperty("pm.or.bgjob_password", s_bgjobuser);
            if (m_pmVersion.startsWith("PM")) {
                extendedProperties.setProperty("pm.or.odsplus_user", s_pxrptuser);
                extendedProperties.setProperty("pm.or.odsplus_password", s_pxrptuser_password);
                extendedProperties.setProperty("pm.or.px_path", "");
                extendedProperties.setProperty("pm.or.px_size", "250M");
                extendedProperties.setProperty("pm.data_tablespace", "PMDB_DAT1");
                extendedProperties.setProperty("pm.index_tablespace", "PMDB_NDX1");
                extendedProperties.setProperty("pm.lob_tablespace", "PMDB_LOB1");
                extendedProperties.setProperty("pm.px_tablespace", "PMDB_PX_DAT1");
            }
            extendedProperties.put("oracle.jdbc.RetainV9LongBindBehavior", "true");
        } else {
            DatabaseConnection dbconn = new DatabaseConnection(dbOperator.getSystemConnection().getConnectstring());
            String masterFileDirectory = CommonMethods.getMasterFileDirectory(dbconn);
            extendedProperties.setProperty("pm.ss.database_name", dbOperator.getDBName());
            extendedProperties.setProperty("pm.ss.data_path", masterFileDirectory + "/" + dbOperator.getDBName() + "_DAT.mdf");
            extendedProperties.setProperty("pm.ss.log_path", masterFileDirectory + "/" + dbOperator.getDBName() + "_lOG.mdf");
            extendedProperties.setProperty("pm.ss.privileged_user", "privuser");
            extendedProperties.setProperty("pm.ss.public_user", "pubuser");
            if (m_pmVersion.startsWith("PM")) {
                extendedProperties.setProperty("pm.ss.odsplus_user", s_pxrptuser);
                extendedProperties.setProperty("pm.ss.odsplus_password", s_pxrptuser_password);
            }
            extendedProperties.setProperty("pm.ss.codepage", "");
        }
        dbOperator.setUpProperties(extendedProperties);
        s_dafDatabaseVersion = DAFImporter.getDafDatabaseVersion(connectFile.getFilename());
        dbOperator.doPreLoadOperations(s_dafDatabaseVersion);
        TableManipulator tm = new TableManipulator();
        tm.getPMSchemaTables(m_pmVersion);
        Dataloader dataloader = new Dataloader();
        dataloader.setSourceConnectString(dbOperator.getLoadFile());
        dataloader.setTargetConnectString(dbOperator.getAdminConnection().getConnectstring());
        if (dataloader.getSourceDS() instanceof ZipDataloaderInputDS) {
            ZipDataloaderInputDS zipInput = (ZipDataloaderInputDS)dataloader.getSourceDS();
            zipInput.setTableManipulator(tm);
        }
        RunDataloader.run(dataloader);
        dbOperator.doPostLoadOperations(s_dafDatabaseVersion);
    }

    private static DBOperationsInterface getDBOperations(String dbType) {
        DBOperationsInterface operations = null;
        if ("oracle".equalsIgnoreCase(dbType)) {
            operations = new CreateOROperations();
        } else if ("sqlserver".equalsIgnoreCase(dbType)) {
            operations = new CreateSSOperations();
        }
        return operations;
    }

    private static void setUp(String[] args) {
        DAFImporter.parseInputParameters(args);
        dbType = primaryConnection.getDbtype().getConnectionTypeName();
    }

    private static void parseInputParameters(String[] args) {
        m_pmVersion = System.getProperty("pm_version");
        if (args.length < 2) {
            System.err.println("Missing input parameters.");
            String runSample = "Usage:ORACLE:\n  DAFImporter.bat /SOURCESTRING:file:path2theDAF.zip  /TARGETSTRING:db:or:username/pass@10.140.168.35:1521:enigma03 -verbose  /ADMUSER:admuser /ADMPASS:admuser /PUBUSER:pubuser /PRIVUSER:privuserSQLSERVER:\nDAFImporter.bat /SOURCESTRING:file:path2theDAF.zip  /TARGETSTRING:db:ss:username/pass@GSEMINOV-D630:1433:PMDBtest -verbose \n";
            runSample = "DAFImporter.bat -daf file:path2theDAF.zip -connetion username/password@oracle|sqlserver:host:port:instance -action upgrade -key itt34 -verbose -sysuser sysuser -syspass pass -privuser privuser4 -pubuser pubuser4 -bgjobuser bgjobuser";
            System.err.println(runSample);
            Log.warn("Missing input parameters.");
            Log.warn(runSample);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-daf")) {
                if (++i >= args.length) {
                    Log.info("Provide DAF file.");
                    System.exit(-1);
                }
                String DAFfile = null;
                DAFfile = args[i];
                connectFile = new ConnectStringParse(DAFfile);
                Log.info("DAF file(" + DAFfile + ") successfully parsed.");
                continue;
            }
            if (args[i].startsWith("-connection")) {
                if (++i >= args.length) {
                    Log.info("Provide database connection.");
                    System.exit(-1);
                }
                primaryConnection = new ConnectStringParse(args[i]);
                Log.info("DB connection has been successfully parsed.");
                continue;
            }
            if (args[i].startsWith("-verbose")) {
                s_verbose = true;
                Log.info("Verbose flag is set.");
                continue;
            }
            if (args[i].startsWith("-sysuser")) {
                if (++i >= args.length) {
                    Log.info("Provide sysuser name after -sysuser.");
                    System.exit(-1);
                }
                sysUsername = args[i];
                continue;
            }
            if (args[i].startsWith("-syspass")) {
                if (++i >= args.length) {
                    Log.info("Provide system password name after -syspass.");
                    System.exit(-1);
                }
                sysPassword = args[i];
                continue;
            }
            if (args[i].startsWith("-privuser")) {
                if (++i >= args.length) {
                    Log.info("Provide privuser name after -privuser.");
                    System.exit(-1);
                }
                s_privuser = args[i];
                continue;
            }
            if (args[i].startsWith("-pubuser")) {
                if (++i >= args.length) {
                    Log.info("Provide pubuser name after -pubuser.");
                    System.exit(-1);
                }
                s_pubuser = args[i];
                continue;
            }
            if (args[i].startsWith("-bgjobuser")) {
                if (++i >= args.length) {
                    Log.info("Provide bgjobuser name after -bgjobuser.");
                    System.exit(-1);
                }
                s_bgjobuser = args[i];
                continue;
            }
            if (args[i].startsWith("-pxrptpass")) {
                if (++i >= args.length) {
                    Log.info("Provide pxrptuser password after -pxrptpass.");
                    System.exit(-1);
                }
                s_pxrptuser_password = args[i];
                continue;
            }
            if (!args[i].startsWith("-pxrptuser")) continue;
            if (++i >= args.length) {
                Log.info("Provide pxrptuser name after -pxrptuser.");
                System.exit(-1);
            }
            s_pxrptuser = args[i];
        }
        File f = new File(connectFile.getFilename());
        if (!f.exists()) {
            System.err.println("The DAF file (" + connectFile.getFilename() + ") does not exist");
            Log.warn(connectFile.getFilename() + " does not exist.");
            System.exit(-1);
        }
    }

    public static String translateDBconnection(String db) {
        db = db.substring(14);
        int colon = db.indexOf(58);
        db = db.substring(colon + 1);
        colon = db.indexOf(58);
        String serverType = db.substring(0, colon);
        db = db.substring(colon + 1);
        int at = db.indexOf(64);
        db = db.substring(0, at + 1) + serverType + ":" + db.substring(at + 1);
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInstalledVersion(String dbStringConnect) {
        String versionQuery = "select database_version from prefer";
        DatabaseConnection dbconn = null;
        Statement stmt = null;
        try {
            dbconn = new DatabaseConnection(dbStringConnect);
            stmt = dbconn.getConnection().prepareStatement(versionQuery);
            stmt.execute();
            ResultSet resultSet = stmt.getResultSet();
            if (resultSet.next()) {
                String string = resultSet.getString("database_version").substring(5);
                return string;
            }
            try {
                throw new DatabaseToolException("Version string Not found");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    public static String getDafDatabaseVersion(String DafFile) {
        try {
            ZipFile zf = new ZipFile(DafFile);
            ZipEntry ze = zf.getEntry("PREFER.XML");
            InputSource in = new InputSource(zf.getInputStream(ze));
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile("/DATAPACKET/ROWDATA/ROW");
            NodeList nl = (NodeList)expr.evaluate(in, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                NamedNodeMap nnm = nl.item(i).getAttributes();
                Node dirValue = nnm.getNamedItem("database_version");
                if (dirValue == null) continue;
                String databaseVersion = nl.item(i).getAttributes().getNamedItem("database_version").getNodeValue();
                System.out.println("The database version is :" + databaseVersion);
                return databaseVersion.substring(5);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return "";
    }
}

