/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.DAFImporter;

import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.tools.DAFImporter.CommonMethods;
import com.primavera.database.tools.DAFImporter.DBOperationsInterface;
import com.primavera.database.tools.DatabaseToolException;
import java.sql.SQLException;
import java.util.Properties;

public class CreateSSOperations
implements DBOperationsInterface {
    private static String dbType = "sqlserver";
    private static ConnectStringParse connectDBAsSystem = null;
    private static ConnectStringParse connectDBAsAdmuser = null;
    private static String s_connectFileLoad = null;
    private static String m_pmVersion = null;
    private static String m_dbName = null;
    private Properties s_properties = null;

    @Override
    public void doPreLoadOperations(String DAF_pmVersion) {
        try {
            CommonMethods.clearDB(connectDBAsSystem.getConnectstring(), dbType, this.s_properties);
            if (m_pmVersion.startsWith("PPM")) {
                String sqlScript = "install/" + m_pmVersion + "/" + "ssppm_init_db.sql";
                CommonMethods.runDB_Script(connectDBAsSystem.getConnectstring(), sqlScript, this.s_properties);
                sqlScript = "install/" + m_pmVersion + "/" + "ssppm_create_users.sql";
                CommonMethods.runDB_Script(connectDBAsAdmuser.getConnectstring(), sqlScript, this.s_properties);
                sqlScript = DAF_pmVersion + "/" + "sspm_tables.sql";
                CommonMethods.runDB_Script(connectDBAsAdmuser.getConnectstring(), sqlScript, this.s_properties);
            } else {
                String sqlScript = "install/" + m_pmVersion + "/" + "sspm_init_db.sql";
                CommonMethods.runDB_Script(connectDBAsSystem.getConnectstring(), sqlScript, this.s_properties);
                sqlScript = "install/" + m_pmVersion + "/" + "sspm_create_users.sql";
                CommonMethods.runDB_Script(connectDBAsAdmuser.getConnectstring(), sqlScript, this.s_properties);
                sqlScript = DAF_pmVersion + "/" + "sspm_tables.sql";
                CommonMethods.runDB_Script(connectDBAsAdmuser.getConnectstring(), sqlScript, this.s_properties);
            }
        }
        catch (DatabaseToolException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doPostLoadOperations(String DAF_pmVersion) {
        try {
            if (m_pmVersion.startsWith("PPM")) {
                String sqlScript = "ss_set_currency.sql";
                CommonMethods.runDB_Script(connectDBAsAdmuser.getConnectstring(), sqlScript, this.s_properties);
                sqlScript = DAF_pmVersion + "/" + "sspm_ins_aux.sql";
                CommonMethods.runDB_Script(connectDBAsAdmuser.getConnectstring(), sqlScript, this.s_properties);
                sqlScript = "sspm_src.sql";
                CommonMethods.runDB_Script(connectDBAsAdmuser.getConnectstring(), sqlScript, this.s_properties);
                sqlScript = "install/" + m_pmVersion + "/" + "ssppm_create_private_user.sql";
                CommonMethods.runDB_Script(connectDBAsAdmuser.getConnectstring(), sqlScript, this.s_properties);
            } else {
                String sqlScript = "ss_set_currency.sql";
                CommonMethods.runDB_Script(connectDBAsAdmuser.getConnectstring(), sqlScript, this.s_properties);
                sqlScript = DAF_pmVersion + "/" + "sspm_ins_aux.sql";
                CommonMethods.runDB_Script(connectDBAsAdmuser.getConnectstring(), sqlScript, this.s_properties);
                sqlScript = "sspm_src.sql";
                CommonMethods.runDB_Script(connectDBAsAdmuser.getConnectstring(), sqlScript, this.s_properties);
                sqlScript = "install/" + m_pmVersion + "/" + "sspm_create_private_user.sql";
                CommonMethods.runDB_Script(connectDBAsAdmuser.getConnectstring(), sqlScript, this.s_properties);
                sqlScript = "install/" + m_pmVersion + "/" + "sspm_create_plus_users.sql";
                CommonMethods.runDB_Script(connectDBAsAdmuser.getConnectstring(), sqlScript, this.s_properties);
            }
        }
        catch (DatabaseToolException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ConnectStringParse getAdminConnection() {
        return connectDBAsAdmuser;
    }

    @Override
    public String getDBName() {
        return m_dbName;
    }

    @Override
    public String getLoadFile() {
        return s_connectFileLoad;
    }

    @Override
    public ConnectStringParse getSystemConnection() {
        return connectDBAsSystem;
    }

    @Override
    public void setAdminConnection(String connectString) {
        connectDBAsAdmuser = new ConnectStringParse(connectString);
    }

    @Override
    public void setSystemConnection(String connectString, String dummy1, String dummy2) {
        int colon = connectString.lastIndexOf(":");
        m_dbName = connectString.substring(colon + 1);
        String DBAsystem = connectString.substring(0, colon) + ":master";
        connectDBAsSystem = new ConnectStringParse(DBAsystem);
    }

    @Override
    public void setUp(String connectString, String connectFileString, String sysUsername, String sysPassword, String pmVersion) {
        this.setAdminConnection(connectString);
        this.setSystemConnection(connectString, sysUsername, sysPassword);
        int colon = connectString.lastIndexOf(":");
        m_dbName = connectString.substring(colon + 1);
        m_pmVersion = pmVersion;
        s_connectFileLoad = connectFileString;
    }

    @Override
    public void setUpProperties(Properties extendedProperties) throws SQLException {
        this.s_properties = extendedProperties;
    }
}

