/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BlobEncodingUtil {
    public static final String UTF_8 = "UTF-8";
    public static final byte[] UTF_8_BOM = new byte[]{-17, -69, -65};
    private static final Pair[] NON_HTML_BLOBS = new Pair[]{new Pair("RSRCCURV", "CURV_DATA"), new Pair("RPT", "RPT_DATA"), new Pair("PRMQUEUE", "QUEUE_PAYLOAD_EXTENDED"), new Pair("PRMAUDIT", "AUDIT_INFO_EXTENDED"), new Pair("PAUDIT", "AUDIT_EXT_OLD"), new Pair("PAUDIT", "AUDIT_EXT_NEW"), new Pair("PREFER", "LICENSE_DATA"), new Pair("PFOLIO", "PFOLIO_DATA"), new Pair("JOBSVC", "JOB_DATA"), new Pair("JOBRPT", "JOBRPT_DATA"), new Pair("JOBLOG", "JOB_LOG_DATA"), new Pair("ISSUHIST", "ISSUE_HISTORY"), new Pair("GCHANGE", "GCHANGE_DATA"), new Pair("FORMTMPL", "FORM_TMPL_DATA"), new Pair("FILTPROP", "FILTER_DATA"), new Pair("DASHBOARD", "PORTLET_SETTINGS_DATA"), new Pair("CALENDAR", "CLNDR_DATA"), new Pair("ADMIN_CONFIG", "CONFIG_DATA"), new Pair("WORKSPACE", "WORKSPACE_PREFS"), new Pair("VWPREFDATA", "VIEW_PREF_VALUE_BLOB"), new Pair("VIEWPROP", "VIEW_DATA"), new Pair("USERSET", "USERSET_BLOB"), new Pair("USERDATA", "USER_DATA"), new Pair("TRAKVIEW", "TRACK_VIEW_DATA"), new Pair("TIMESHT", "TS_NOTES"), new Pair("TASKRSRC", "RSRC_REQUEST_DATA"), new Pair("TASKNOTE", "TASK_NOTES"), new Pair("TASKFDBK", "TASK_FDBK"), new Pair("PROJPROP", "PROP_VALUE"), new Pair("OBS", "OBS_DESCR")};
    private static Map<String, Set<String>> NON_HTML_BLOB_TABLE = BlobEncodingUtil.initializeNonHtmlBlobTable(NON_HTML_BLOBS);

    public static boolean isNonHTMLField(String tableName, String fieldName) {
        Set<String> fields = NON_HTML_BLOB_TABLE.get(tableName.toUpperCase());
        return fields != null && fields.contains(fieldName.toUpperCase());
    }

    public static boolean hasBOM(byte[] bytes) {
        if (bytes.length < UTF_8_BOM.length) {
            return false;
        }
        for (int i = 0; i < UTF_8_BOM.length; ++i) {
            if (bytes[i] == UTF_8_BOM[i]) continue;
            return false;
        }
        return true;
    }

    private static Map<String, Set<String>> initializeNonHtmlBlobTable(Pair[] nonHtmlBlobs) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (Pair p : nonHtmlBlobs) {
            Set<String> fields = map.get(p.first.toUpperCase());
            if (fields == null) {
                fields = new HashSet<String>();
                map.put(p.first.toUpperCase(), fields);
            }
            fields.add(p.second.toUpperCase());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDBEncoding(Connection conn) throws SQLException {
        try (CallableStatement cs = null;){
            cs = conn.prepareCall("{call db_to_iana_charset( ? )}");
            cs.registerOutParameter(1, 1);
            cs.execute();
            String encoding = cs.getString(1);
            if (encoding == null) {
                String string = UTF_8;
                return string;
            }
            String string = encoding.toUpperCase();
            return string;
        }
    }

    public static void dbgOut(String msg) {
        DBMTLogger.info(Channel.DEV, msg);
    }

    public static void dbgBlob(byte[] blobData) {
        String blobString = "ABCDEF";
        int offset = 0;
        if (BlobEncodingUtil.hasBOM(blobData)) {
            offset = UTF_8_BOM.length;
        }
        byte[] bytes = Arrays.copyOfRange(blobData, offset, 12);
        try {
            blobString = new String(bytes, UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        System.out.println(blobString);
        for (int i = 0; i < 12 + offset; ++i) {
            if (i >= blobData.length) continue;
            System.out.print(" " + blobData[i]);
        }
        System.out.println();
    }

    public static String toStringWithUTF8(byte[] bytes) {
        try {
            return new String(bytes, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    public static void throwError() {
        Object b = null;
        b.toString();
    }

    private static final class Pair {
        public final String first;
        public final String second;

        public Pair(String f, String s) {
            this.first = f;
            this.second = s;
        }
    }
}

