/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.locale;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import java.util.ArrayList;
import java.util.List;

public abstract class StringLocalizer {
    private static StringLocalizer s_instance;
    private static final String[] EMPTY_STRING_ARRAY;
    static final StateAction outSpanAction;
    static final StateAction onOpenAction;
    static final StateAction onCloseAction;
    static final StateAction inSpanAction;
    static final StateAction onEscapeAction;

    private static String stringNotFoundResult(String key) {
        return "{" + key + "}";
    }

    public static synchronized StringLocalizer getInstance() {
        return s_instance;
    }

    public static synchronized void setInstance(StringLocalizer inst) {
        s_instance = inst;
    }

    public abstract String lookup(String var1) throws LocalizedStringNotFound;

    public abstract void setString(String var1, String var2);

    public abstract void importProperties(String var1);

    public static String get(String key) {
        return StringLocalizer.get(key, EMPTY_STRING_ARRAY, true);
    }

    public static String get(String key, boolean throwOnMissing) {
        return StringLocalizer.get(key, EMPTY_STRING_ARRAY, throwOnMissing);
    }

    public static void importStrings(String propertiesFileLocation) {
        StringLocalizer.getInstance().importProperties(propertiesFileLocation);
    }

    public static void setAsOwnTranslation(String stringKeyAndValue) {
        StringLocalizer.getInstance().setString(stringKeyAndValue, stringKeyAndValue);
    }

    public static String get(String key, String[] args) {
        return StringLocalizer.get(key, args, true);
    }

    public static String get(String key, String[] args, boolean throwsOnMissing) {
        try {
            String translatedStringTemplate = StringLocalizer.getInstance().lookup(key);
            if (args.length == 0) {
                return translatedStringTemplate;
            }
            StringSpan[] spans = StringLocalizer.findArgumentSpans(key, translatedStringTemplate);
            if (spans.length == 0) {
                return translatedStringTemplate;
            }
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(translatedStringTemplate.substring(0, spans[0].getFrom()));
            for (int i = 0; i < spans.length; ++i) {
                StringSpan span = spans[i];
                String replacementValue = translatedStringTemplate.substring(span.getFrom(), span.getFrom() + span.getLength());
                if (span.getArgIndex() < args.length) {
                    replacementValue = args[span.getArgIndex()];
                }
                sbuf.append(replacementValue);
                int start = span.getFrom() + span.getLength();
                int end = translatedStringTemplate.length();
                if (i + 1 < spans.length) {
                    end = spans[i + 1].getFrom();
                }
                sbuf.append(translatedStringTemplate.substring(start, end));
            }
            return sbuf.toString();
        }
        catch (LocalizationError e) {
            if (!throwsOnMissing) {
                return null;
            }
            DBMTLogger.error(Channel.USER, e.getClass().getSimpleName() + " thrown retrieving value of " + key + ": " + e.getLocalizationErrorText());
            return StringLocalizer.stringNotFoundResult(key);
        }
    }

    private static StringSpan[] findArgumentSpans(String key, String stringTemplate) throws VariableInterpolationError {
        ArrayList<StringSpan> spans = new ArrayList<StringSpan>();
        IntegerRef spanStart = new IntegerRef();
        StateAction nextAction = States.OUT_SPAN.getTransAction();
        for (int i = 0; i < stringTemplate.length(); ++i) {
            nextAction = nextAction.doChar(key, stringTemplate, i, spans, spanStart);
        }
        if (spanStart.isSet()) {
            int start = spanStart.getIntegerValue();
            String argIndexString = stringTemplate.substring(start + 1, stringTemplate.length() - 1);
            int argIndex = 0;
            try {
                argIndex = Integer.parseInt(argIndexString);
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentIndexNumberFormatError(key, stringTemplate, argIndexString);
            }
            spans.add(new StringSpan(start, stringTemplate.length() - start, argIndex));
        }
        return spans.toArray(new StringSpan[0]);
    }

    static {
        EMPTY_STRING_ARRAY = new String[0];
        outSpanAction = new StateAction(){

            @Override
            public StateAction doChar(String key, String string, int index, List<StringSpan> spans, IntegerRef spanStart) throws VariableInterpolationError {
                switch (string.charAt(index)) {
                    case '\'': {
                        return States.ON_ESCAPE.getTransAction();
                    }
                    case '{': {
                        spanStart.setIntegerValue(index);
                        return States.ON_OPEN.getTransAction();
                    }
                }
                return States.OUT_SPAN.getTransAction();
            }
        };
        onOpenAction = new StateAction(){

            @Override
            public StateAction doChar(String key, String string, int index, List<StringSpan> spans, IntegerRef spanStart) throws VariableInterpolationError {
                if (!Character.isDigit(string.charAt(index))) {
                    throw new UnableToParserVariableIndex(key, string, index);
                }
                return States.IN_SPAN.getTransAction();
            }
        };
        onCloseAction = new StateAction(){

            @Override
            public StateAction doChar(String key, String string, int index, List<StringSpan> spans, IntegerRef spanStart) throws VariableInterpolationError {
                int integerValue = spanStart.getIntegerValue();
                String argIndexString = string.substring(integerValue + 1, index - 1);
                int argIndex = 0;
                try {
                    argIndex = Integer.parseInt(argIndexString);
                }
                catch (NumberFormatException e) {
                    throw new InvalidArgumentIndexNumberFormatError(key, string, argIndexString);
                }
                spans.add(new StringSpan(integerValue, index - integerValue, argIndex));
                return States.OUT_SPAN.getTransAction();
            }
        };
        inSpanAction = new StateAction(){

            @Override
            public StateAction doChar(String key, String string, int index, List<StringSpan> spans, IntegerRef spanStart) throws VariableInterpolationError {
                if (string.charAt(index) == '}') {
                    return States.ON_CLOSE.getTransAction();
                }
                if (!Character.isDigit(string.charAt(index))) {
                    throw new UnableToParserVariableIndex(key, string, index);
                }
                return States.IN_SPAN.getTransAction();
            }
        };
        onEscapeAction = new StateAction(){

            @Override
            public StateAction doChar(String key, String string, int index, List<StringSpan> spans, IntegerRef spanStart) throws VariableInterpolationError {
                return States.OUT_SPAN.getTransAction();
            }
        };
    }

    public static abstract class LocalizationError
    extends Exception {
        private static final long serialVersionUID = 3384378364376837114L;
        protected final String m_string;

        public LocalizationError(String string) {
            this.m_string = string;
        }

        public abstract String getLocalizationErrorText();
    }

    public static class InvalidArgumentIndexNumberFormatError
    extends InvalidArgumentIndexError {
        private static final long serialVersionUID = -7079257144477838026L;
        protected String m_invalidFormattedNumber;

        public InvalidArgumentIndexNumberFormatError(String key, String transString, String invalidFormattedNumber) {
            super(key, transString);
            this.m_invalidFormattedNumber = invalidFormattedNumber;
        }

        @Override
        public String getLocalizationErrorText() {
            return "Unable to parse \"" + this.m_invalidFormattedNumber + "\" in localized string \"" + this.m_localizedString + "\"";
        }
    }

    public static class UnableToParserVariableIndex
    extends InvalidArgumentIndexError {
        private static final long serialVersionUID = -7079257144477838026L;
        protected int m_invalidCharacterOffset;

        public UnableToParserVariableIndex(String key, String transString, int numberOffset) {
            super(key, transString);
            this.m_invalidCharacterOffset = numberOffset;
        }
    }

    public static class InvalidArgumentIndexError
    extends VariableInterpolationError {
        private static final long serialVersionUID = -7079257144477838026L;
        protected String m_localizedString;

        public InvalidArgumentIndexError(String key, String transString) {
            super(key);
            this.m_localizedString = transString;
        }
    }

    public static class VariableInterpolationError
    extends LocalizationError {
        private static final long serialVersionUID = -5641323646786412405L;

        public VariableInterpolationError(String string) {
            super(string);
        }

        @Override
        public String getLocalizationErrorText() {
            return "Unable to perform variable interpolation for string";
        }
    }

    public class LocalizedStringNotFound
    extends LocalizationError {
        private static final long serialVersionUID = 8553626811313901249L;

        public LocalizedStringNotFound(String string) {
            super(string);
        }

        @Override
        public String getLocalizationErrorText() {
            return "Unable to find localized string";
        }
    }

    private static enum States {
        OUT_SPAN(outSpanAction),
        ON_ESCAPE(onEscapeAction),
        ON_OPEN(onOpenAction),
        ON_CLOSE(onCloseAction),
        IN_SPAN(inSpanAction);

        private StateAction m_transAction;

        private States(StateAction action) {
            this.m_transAction = action;
        }

        public StateAction getTransAction() {
            return this.m_transAction;
        }

        public void setTransAction(StateAction a) {
            this.m_transAction = a;
        }
    }

    private static interface StateAction {
        public StateAction doChar(String var1, String var2, int var3, List<StringSpan> var4, IntegerRef var5) throws VariableInterpolationError;
    }

    private static class IntegerRef {
        private int m_integerValue = 0;
        private boolean m_isSet = false;

        private IntegerRef() {
        }

        public final int getIntegerValue() {
            this.m_isSet = false;
            int returnVal = this.m_integerValue;
            this.m_integerValue = 0;
            return returnVal;
        }

        public final void setIntegerValue(int integerValue) {
            this.m_integerValue = integerValue;
            this.m_isSet = true;
        }

        public final boolean isSet() {
            return this.m_isSet;
        }
    }

    private static class StringSpan {
        private final int m_from;
        private final int m_length;
        private final int m_argIndex;

        public StringSpan(int from, int length, int argIndex) {
            this.m_from = from;
            this.m_length = length;
            this.m_argIndex = argIndex;
        }

        public final int getFrom() {
            return this.m_from;
        }

        public final int getLength() {
            return this.m_length;
        }

        public final int getArgIndex() {
            return this.m_argIndex;
        }
    }
}

