/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.dbo;

public class DatabaseColumn {
    private String name;
    private String tableName;
    private String columnName;
    private String dataType;
    private String genericDataType;
    private int length;
    private int precision;
    private int scale;
    private boolean notNull;
    private String defaultValue = new String("");

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        if (defaultValue == null) {
            return;
        }
        this.defaultValue = defaultValue.toLowerCase().contains("getdate") ? "sysdate" : (defaultValue.startsWith("(", 0) ? defaultValue.substring(1, defaultValue.length() - 1) : defaultValue);
    }

    public int getLength() {
        if ("integer".equalsIgnoreCase(this.genericDataType)) {
            return 10;
        }
        if ("date".equalsIgnoreCase(this.genericDataType)) {
            return 7;
        }
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
        this.genericDataType = this.genericDataType(dataType);
    }

    public String getGenericDataType() {
        return this.genericDataType;
    }

    public void setGenericDataType(String genericDataType) {
        this.genericDataType = genericDataType;
    }

    public String getNotNullFlag() {
        if (this.notNull) {
            return "Y";
        }
        return "N";
    }

    private String genericDataType(String type) {
        if ("varchar2".equalsIgnoreCase(type) || "varchar".equalsIgnoreCase(type) || "nvarchar".equalsIgnoreCase(type)) {
            return "string";
        }
        if ("int".equalsIgnoreCase(type) || "int identity".equalsIgnoreCase(type)) {
            return "integer";
        }
        if ("datetime".equalsIgnoreCase(type) || "date".equalsIgnoreCase(type)) {
            return "date";
        }
        if ("text".equalsIgnoreCase(type) || "blob".equalsIgnoreCase(type)) {
            return "blob";
        }
        if ("clob".equalsIgnoreCase(type)) {
            return "clob";
        }
        if ("char".equalsIgnoreCase(type)) {
            return "character";
        }
        if ("decimal".equalsIgnoreCase(type)) {
            return "number";
        }
        if ("numeric".equalsIgnoreCase(type) || "number".equalsIgnoreCase(type)) {
            if (this.precision == 10 && this.scale == 0) {
                return "integer";
            }
            return "double";
        }
        if ("sdo_geometry".equalsIgnoreCase(type)) {
            return "geometry";
        }
        return "UNKNOWN";
    }
}

