/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.argsprocessor;

import com.primavera.database.common.argsprocessor.ArgumentProcessor;
import com.primavera.database.common.argsprocessor.ParameterDef;
import com.primavera.database.common.argsprocessor.StringTracker;

public class StringDef
extends ParameterDef {
    public StringDef(char chr, String name, String desc) {
        super(chr, name, desc);
    }

    public StringDef(char chr, String name) {
        this(chr, name, null);
    }

    @Override
    protected void bindToClass(Class<?> clas) {
        super.bindToClass(clas);
        Class<?> type = this.m_field.getType();
        if (type != String.class) {
            throw new IllegalArgumentException("Field '" + this.m_name + "'in " + clas.getName() + " is not of type String");
        }
    }

    @Override
    public void handle(ArgumentProcessor proc) {
        StringTracker args = proc.getArgs();
        if (args.hasNext()) {
            String arg = args.next();
            if (arg.length() > 0 && arg.charAt(0) == '-') {
                proc.reportArgumentError(this.m_char, "Argument value starts with '-'");
            } else {
                proc.setValue(arg, this.m_field);
            }
        } else {
            proc.reportArgumentError(this.m_char, "Argument value missing");
        }
    }
}

