/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.argsprocessor;

import com.primavera.database.common.argsprocessor.ArgumentProcessor;
import java.lang.reflect.Field;

public abstract class ParameterDef {
    protected final char m_char;
    protected final String m_name;
    protected final String m_description;
    protected Field m_field;

    protected ParameterDef(char chr, String name, String desc) {
        this.m_char = chr;
        this.m_name = name;
        this.m_description = desc == null ? "[see code for description]" : desc;
    }

    public String getAbbreviation() {
        return "-" + this.m_char;
    }

    public char getFlag() {
        return this.m_char;
    }

    public String getDescription() {
        return this.m_description;
    }

    protected void bindToClass(Class<?> clas) {
        try {
            this.m_field = clas.getDeclaredField(this.m_name);
            this.m_field.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalArgumentException("Field '" + this.m_name + "' not found in " + clas.getName());
        }
    }

    public abstract void handle(ArgumentProcessor var1);
}

