/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.argsprocessor;

import com.primavera.database.common.argsprocessor.ArgumentProcessor;
import com.primavera.database.common.argsprocessor.CharTracker;
import com.primavera.database.common.argsprocessor.ParameterDef;

public class FloatDef
extends ParameterDef {
    private final float m_min;
    private final float m_max;

    public FloatDef(char chr, String name, String desc, float min, float max) {
        super(chr, name, desc);
        this.m_min = min;
        this.m_max = max;
    }

    public FloatDef(char chr, String name, float min, float max) {
        this(chr, name, null, min, max);
    }

    public FloatDef(char chr, String name, String desc) {
        this(chr, name, desc, Float.MIN_VALUE, Float.MAX_VALUE);
    }

    public FloatDef(char chr, String name) {
        this(chr, name, null);
    }

    @Override
    public String getAbbreviation() {
        return "-" + this.m_char + "NN";
    }

    @Override
    protected void bindToClass(Class<?> clas) {
        super.bindToClass(clas);
        Class<?> type = this.m_field.getType();
        if (type != Float.class && type != Float.TYPE) {
            throw new IllegalArgumentException("Field '" + this.m_name + "'in " + clas.getName() + " is not of type float");
        }
    }

    @Override
    public void handle(ArgumentProcessor proc) {
        float value = 0.0f;
        CharTracker track = proc.getChars();
        StringBuffer text = new StringBuffer();
        if (track.hasNext()) {
            char chr = track.peek();
            if (chr == '-' || chr == '+') {
                text.append(chr);
                track.next();
            }
            while (track.hasNext() && ((chr = track.peek()) >= '0' && chr <= '9' || chr == '.')) {
                text.append(chr);
                track.next();
            }
        }
        try {
            value = Float.parseFloat(text.toString());
        }
        catch (NumberFormatException ex) {
            proc.reportArgumentError(this.m_char, ex.getMessage());
        }
        if (value < this.m_min || value > this.m_max) {
            proc.reportArgumentError(this.m_char, "Value out of range");
        } else {
            proc.setValue(new Float(value), this.m_field);
        }
    }
}

