/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import java.sql.Driver;
import java.sql.DriverManager;

public enum ServerType {
    ORACLE("Oracle", "or", "oracle", 1521, "admuser", "dual", "oracle.jdbc.OracleDriver"),
    SQLSERVER("Microsoft", "ss", "sqlserver", 1433, "sa", "master", "com.microsoft.sqlserver.jdbc.SQLServerDriver"),
    ORACLEATP("Oracle_ATP", "or_atp", "oracle_atp", 1522, "admuser", "dual", "oracle.jdbc.OracleDriver"),
    SYBASE("Adaptive", "asa", "sybase", 2638, "dba", "dual", "com.microsoft.sqlserver.jdbc.SQLServerDriver");

    public static final String ORACLE_CONNECTION_TYPE_SERVICE = "SERVICE";
    public static final String ORACLE_CONNECTION_TYPE_SID = "SID";
    private final String m_vendorName;
    private final String m_shortName;
    private final String m_connectStringName;
    private final int m_defaultPortNumber;
    private final String m_administratorName;
    private final String m_defaultDb;

    private ServerType(String vendName, String shortName, String connectStringName, int portNum, String adminName, String defaultDb, String driverName) {
        this.m_vendorName = vendName;
        this.m_shortName = shortName;
        this.m_connectStringName = connectStringName;
        this.m_defaultPortNumber = portNum;
        this.m_administratorName = adminName;
        this.m_defaultDb = defaultDb;
        this.registerDriver(driverName);
    }

    public void registerDriver(String driverName) {
        try {
            Object obj = Class.forName(driverName).newInstance();
            if (obj instanceof Driver) {
                DriverManager.registerDriver((Driver)obj);
            } else {
                DBMTLogger.error(Channel.USER, "Error creating driver for database type " + (Object)((Object)this) + ": " + obj + " is not a " + Driver.class.getName());
            }
        }
        catch (Exception e) {
            DBMTLogger.error(Channel.USER, "Error creating driver for database type " + (Object)((Object)this) + ": " + e.toString());
        }
    }

    public final String getAdministratorName() {
        return this.m_administratorName;
    }

    public final int getDefaultPortNumber() {
        return this.m_defaultPortNumber;
    }

    public final String getVendorName() {
        return this.m_vendorName;
    }

    public final String getShortName() {
        return this.m_shortName;
    }

    public final String getUsername(String userName) {
        if (userName == null || "".equals(userName)) {
            return this.getAdministratorName();
        }
        return userName;
    }

    public final int getPort(int portNum) {
        if (portNum == 0) {
            return this.getDefaultPortNumber();
        }
        return portNum;
    }

    public final String getDefaultDb() {
        return this.m_defaultDb;
    }

    public String getConnectionTypeName() {
        return this.m_connectStringName;
    }
}

