/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common;

import com.primavera.database.common.DataDictionary;
import com.primavera.database.common.GenericDataTypes;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public final class DatabaseHelper {
    private static final String[] m_Disable_Trigger_Table_List = new String[]{"PROJWBS"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkQueryForError(Connection conn, String query) {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            if (!rs.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static String runOneResult(Connection conn, String query) throws SQLException {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            throw new SQLException("No data found");
        }
    }

    public static ServerType getServerType(Connection conn) {
        try {
            DatabaseMetaData meta = conn.getMetaData();
            String vendor = meta.getDatabaseProductName();
            if ("Oracle".equalsIgnoreCase(vendor)) {
                return ServerType.ORACLE;
            }
            if (vendor.toLowerCase().contains("sql server")) {
                return ServerType.SQLSERVER;
            }
            if ("Oracle_ATP".equalsIgnoreCase(vendor)) {
                return ServerType.ORACLEATP;
            }
            return ServerType.SYBASE;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static GenericDataTypes genericFromJavaType(int javatype) {
        switch (javatype) {
            case -9: 
            case 1: 
            case 12: {
                return GenericDataTypes.STRING;
            }
            case 5: {
                return GenericDataTypes.SMALLINT;
            }
            case -6: {
                return GenericDataTypes.TINYINT;
            }
            case 4: {
                return GenericDataTypes.INTEGER;
            }
            case 91: 
            case 92: 
            case 93: {
                return GenericDataTypes.DATE;
            }
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return GenericDataTypes.NUMBER;
            }
            case -1: 
            case 2005: {
                return GenericDataTypes.MEMO;
            }
            case -16: {
                return GenericDataTypes.XMLTYPE;
            }
            case -4: 
            case 2004: {
                return GenericDataTypes.BLOB;
            }
            case 2002: {
                return GenericDataTypes.GEOMETRY;
            }
            case -3: 
            case -2: {
                return GenericDataTypes.BINARY;
            }
        }
        return GenericDataTypes.UNKNOWN;
    }

    public static int javaFromGenericType(GenericDataTypes generictype) {
        switch (generictype) {
            case SMALLINT: {
                return 5;
            }
            case TINYINT: {
                return -6;
            }
            case INTEGER: {
                return 4;
            }
            case DATE: {
                return 91;
            }
            case NUMBER: {
                return 2;
            }
            case MEMO: {
                return -1;
            }
            case BLOB: {
                return -4;
            }
            case BINARY: {
                return -2;
            }
            case XMLTYPE: {
                return -16;
            }
            case GEOMETRY: {
                return 2002;
            }
        }
        return 12;
    }

    public static String getCurrentSchema(Connection conn) {
        ServerType st = DatabaseHelper.getServerType(conn);
        String sql = "";
        if (st == ServerType.ORACLE || st == ServerType.ORACLEATP) {
            sql = "select user from dual";
        } else if (st == ServerType.SQLSERVER) {
            sql = "select name from sysusers where uid in (select uid from master..sysprocesses where spid = @@spid)";
        } else if (st == ServerType.SYBASE) {
            sql = "select current user";
        }
        try {
            String usr = "";
            ResultSet rs = conn.createStatement().executeQuery(sql);
            usr = rs.next() ? rs.getString(1) : "UNK";
            rs.getStatement().close();
            rs.close();
            return usr;
        }
        catch (SQLException ex) {
            return "UNK";
        }
    }

    public static String getTableOwner(Connection conn, String table) {
        ServerType st = DatabaseHelper.getServerType(conn);
        String sql = "";
        String own = "";
        if (st == ServerType.ORACLE || st == ServerType.ORACLEATP) {
            try {
                if (DatabaseHelper.runOneResult(conn, "select count(*) from user_tables where table_name = '" + table + "'").equalsIgnoreCase("1")) {
                    return DatabaseHelper.getCurrentSchema(conn);
                }
            }
            catch (SQLException e) {
                return "";
            }
            sql = "select distinct owner from user_tab_privs where table_name =  ";
        } else if (st == ServerType.SQLSERVER) {
            sql = "select su.name from sysobjects so, sysusers su where so.type = 'U' and su.uid = so.uid and so.name = ";
        } else if (st == ServerType.SYBASE) {
            sql = "select CREATOR from syscatalog where tname =";
        }
        sql = sql + "'" + table + "'";
        try {
            ResultSet rs = conn.createStatement().executeQuery(sql);
            own = rs.next() ? rs.getString(1) : "";
            rs.getStatement().close();
            rs.close();
            return own;
        }
        catch (SQLException ex) {
            return "";
        }
    }

    public static String getSchemaVersionString(Connection conn) {
        try {
            String tabOwner;
            DataDictionary dd = new DataDictionary(conn);
            String verTab = "CVRT";
            if (!dd.tableExists("CVRT")) {
                verTab = "PREFER";
            }
            if ((tabOwner = DatabaseHelper.getTableOwner(conn, verTab)).length() == 0) {
                return "";
            }
            tabOwner = tabOwner + ".";
            if (verTab == "CVRT") {
                return DatabaseHelper.runOneResult(conn, "select to_version from " + tabOwner + "cvrt" + " where date_converted = (select max(date_converted) from " + tabOwner + "cvrt)");
            }
            return DatabaseHelper.runOneResult(conn, "select database_version from " + tabOwner + "prefer");
        }
        catch (SQLException ex) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateTable(Connection conn, String tablename, ServerType type) throws SQLException {
        String tableOwner = DatabaseHelper.getTableOwner(conn, tablename);
        Statement stmt = conn.createStatement();
        if (type == ServerType.ORACLE || type == ServerType.ORACLEATP) {
            String mquery = "select table_name,constraint_name from user_constraints where r_constraint_name =(select constraint_name from user_constraints where table_name='" + tablename + "' and constraint_type='P')";
            List<String> tablecons = DatabaseHelper.getTableConstraints(conn, mquery);
            for (String string : tablecons) {
                String[] vals = string.split(",");
                stmt.execute("alter table " + vals[0] + " disable constraint " + vals[1]);
            }
            String fkquery = "select table_name,constraint_name from user_constraints where constraint_name in(select constraint_name from user_constraints where table_name='" + tablename + "' and constraint_type='R' and status='ENABLED')";
            List<String> tablefkcons = DatabaseHelper.getTableConstraints(conn, fkquery);
            for (String string : tablefkcons) {
                String[] vals = string.split(",");
                stmt.execute("alter table " + vals[0] + " disable constraint " + vals[1]);
            }
            try {
                stmt.execute("truncate table " + tableOwner + "." + tablename);
            }
            finally {
                stmt.close();
            }
        }
        try {
            stmt.execute("delete from " + tableOwner + "." + tablename);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getTableConstraints(Connection conn, String query) throws SQLException {
        ArrayList<String> ret = new ArrayList<String>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            while (rs.next()) {
                ret.add(rs.getString(1) + "," + rs.getString(2));
            }
        }
        return ret;
    }

    public static void enableForeignkeys(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        String mquery = "select table_name,constraint_name from user_constraints where constraint_type ='R' and status='DISABLED'";
        List<String> tablecons = DatabaseHelper.getTableConstraints(conn, mquery);
        for (String string : tablecons) {
            String[] vals = string.split(",");
            stmt.execute("alter table " + vals[0] + " enable constraint " + vals[1]);
        }
    }

    public static void enableTriggers(String tableName, Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        String trigquery = "alter table " + tableName + " enable all triggers";
        stmt.execute(trigquery);
    }

    public static void disableTriggers(String tableName, Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        String trigquery = "alter table " + tableName + " disable all triggers";
        stmt.execute(trigquery);
    }

    public static void disableTblTrigger(Connection conn, ServerType type) throws SQLException {
        Statement stmt = conn.createStatement();
        for (int i = 0; i < m_Disable_Trigger_Table_List.length; ++i) {
            String trigquery = type == ServerType.ORACLE || type == ServerType.ORACLEATP ? "alter table " + m_Disable_Trigger_Table_List[i] + " disable all triggers" : "alter table " + m_Disable_Trigger_Table_List[i] + " disable trigger all";
            stmt.execute(trigquery);
        }
    }

    public static void enableTblTrigger(Connection conn, ServerType type) throws SQLException {
        Statement stmt = conn.createStatement();
        for (int i = 0; i < m_Disable_Trigger_Table_List.length; ++i) {
            String trigquery = type == ServerType.ORACLE || type == ServerType.ORACLEATP ? "alter table " + m_Disable_Trigger_Table_List[i] + " enable all triggers" : "alter table " + m_Disable_Trigger_Table_List[i] + " enable trigger all";
            stmt.execute(trigquery);
        }
    }

    public static String getColumnDataType(Connection conn, String tablename, String columnname) throws SQLException {
        String datatype = "";
        ServerType st = DatabaseHelper.getServerType(conn);
        String sql = null;
        if (st == ServerType.ORACLE || st == ServerType.ORACLEATP) {
            sql = "select data_type from all_tab_columns where table_name = ? and column_name = ?";
        } else if (st == ServerType.SQLSERVER) {
            sql = "select st.name from syscolumns sc , sysobjects so, systypes st where sc.id = so.id and so.type = 'U' and st.xtype=sc.xtype and so.name = ? and sc.name = ?";
        } else if (st == ServerType.SYBASE) {
            sql = "select coltype from syscolumns where tname = ? and cname = ? ";
        }
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setString(1, tablename);
        stmt.setString(2, columnname);
        stmt.execute();
        ResultSet rs = stmt.getResultSet();
        if (rs.next()) {
            datatype = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return datatype;
    }

    public static String ServerTypeToString(ServerType serverType) {
        switch (serverType) {
            case SYBASE: {
                return "ASA";
            }
            case SQLSERVER: {
                return "SS";
            }
        }
        return "OR";
    }

    public static void setSqlServerIdentityInsert(DatabaseConnection dbconn, String table, boolean value) throws SQLException {
        block3: {
            if (dbconn.getServerType() != ServerType.SQLSERVER) {
                return;
            }
            Statement stmt = dbconn.getConnection().createStatement();
            try {
                String sql = "set identity_insert " + table;
                sql = value ? sql + " on" : sql + " off";
                stmt.execute(sql);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 8106) break block3;
                throw e;
            }
        }
    }
}

